/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.parsepasses.contextautoesc.CheckEscapingSanityVisitor;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.InferenceEngine;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.parsepasses.contextautoesc.PerformDeprecatedNonContextualAutoescapeVisitor;
import com.google.template.soy.parsepasses.contextautoesc.Rewriter;
import com.google.template.soy.parsepasses.contextautoesc.SlicedRawTextNode;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.parsepasses.contextautoesc.TemplateCallGraph;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;

public final class ContextualAutoescaper {
    @VisibleForTesting
    static final String AUTOESCAPE_ERROR_PREFIX = "Invalid or ambiguous syntax prevents Soy from escaping this template correctly:\n";
    private static final SoyErrorKind AUTOESCAPE_ERROR = SoyErrorKind.of("Invalid or ambiguous syntax prevents Soy from escaping this template correctly:\n{0}");
    private final ImmutableSet<String> autoescapeCancellingDirectives;
    private final Map<String, SanitizedContent.ContentKind> sanitizedContentOperators;
    private Inferences inferences;
    private ImmutableList<SlicedRawTextNode> slicedRawTextNodes;
    private static final Predicate<TemplateNode> REQUIRES_INFERENCE = new Predicate<TemplateNode>(){

        @Override
        public boolean apply(TemplateNode templateNode) {
            return templateNode.getAutoescapeMode() == AutoescapeMode.STRICT || templateNode.getAutoescapeMode() == AutoescapeMode.CONTEXTUAL;
        }
    };

    @Inject
    ContextualAutoescaper(final ImmutableMap<String, ? extends SoyPrintDirective> soyDirectivesMap) {
        this(ImmutableSet.copyOf(Collections2.filter(soyDirectivesMap.keySet(), new Predicate<String>(){

            @Override
            public boolean apply(String directiveName) {
                return ((SoyPrintDirective)soyDirectivesMap.get(directiveName)).shouldCancelAutoescape();
            }
        })), ContextualAutoescaper.makeOperatorKindMap(soyDirectivesMap));
    }

    public ContextualAutoescaper(Iterable<String> autoescapeCancellingDirectives, Map<String, SanitizedContent.ContentKind> sanitizedContentOperators) {
        this.autoescapeCancellingDirectives = ImmutableSet.copyOf(autoescapeCancellingDirectives);
        this.sanitizedContentOperators = ImmutableMap.copyOf(sanitizedContentOperators);
    }

    public List<TemplateNode> rewrite(SoyFileSetNode fileSet, TemplateRegistry registry, ErrorReporter errorReporter) {
        ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
        new CheckEscapingSanityVisitor(registry, errorReporter).exec(fileSet);
        if (errorReporter.errorsSince(checkpoint)) {
            return ImmutableList.of();
        }
        ImmutableList files = ImmutableList.copyOf(fileSet.getChildren());
        Map<String, ImmutableList<TemplateNode>> templatesByName = ContextualAutoescaper.findTemplates(files);
        Inferences inferences = new Inferences(this.autoescapeCancellingDirectives, fileSet.getNodeIdGenerator(), templatesByName);
        ImmutableList.Builder<SlicedRawTextNode> slicedRawTextNodesBuilder = ImmutableList.builder();
        List<TemplateNode> allTemplates = inferences.getAllTemplates();
        TemplateCallGraph callGraph = new TemplateCallGraph(templatesByName);
        Collection<TemplateNode> thatRequireInference = Collections2.filter(allTemplates, REQUIRES_INFERENCE);
        Set<TemplateNode> templateNodesToType = callGraph.callersOf(thatRequireInference);
        templateNodesToType.addAll(thatRequireInference);
        HashSet<SourceLocation> errorLocations = new HashSet<SourceLocation>();
        for (TemplateNode templateNode : templateNodesToType) {
            try {
                Context startContext = templateNode.getContentKind() != null ? Context.getStartContextForContentKind(templateNode.getContentKind()) : Context.HTML_PCDATA;
                InferenceEngine.inferTemplateEndContext(templateNode, startContext, inferences, this.autoescapeCancellingDirectives, slicedRawTextNodesBuilder, errorReporter);
            }
            catch (SoyAutoescapeException e) {
                this.reportError(errorReporter, errorLocations, e);
            }
        }
        if (!errorLocations.isEmpty()) {
            return ImmutableList.of();
        }
        this.inferences = inferences;
        this.slicedRawTextNodes = slicedRawTextNodesBuilder.build();
        this.runVisitorOnAllTemplatesIncludingNewOnes(inferences, new NonContextualTypedRenderUnitNodesVisitor(errorReporter));
        List<TemplateNode> extraTemplates = new Rewriter(inferences, this.sanitizedContentOperators, errorReporter).rewrite(fileSet);
        this.runVisitorOnAllTemplatesIncludingNewOnes(inferences, new PerformDeprecatedNonContextualAutoescapeVisitor(this.autoescapeCancellingDirectives, errorReporter, fileSet.getNodeIdGenerator()));
        return extraTemplates;
    }

    private void runVisitorOnAllTemplatesIncludingNewOnes(Inferences inferences, AbstractSoyNodeVisitor<?> visitor) {
        List<TemplateNode> allTemplatesIncludingNewOnes = inferences.getAllTemplates();
        for (TemplateNode templateNode : allTemplatesIncludingNewOnes) {
            visitor.exec(templateNode);
        }
    }

    public Context getTemplateEndContext(String templateName) {
        return this.inferences.getTemplateEndContext(templateName);
    }

    public ImmutableList<SlicedRawTextNode> getSlicedRawTextNodes() {
        return this.slicedRawTextNodes;
    }

    private void reportError(ErrorReporter errorReporter, Set<SourceLocation> errorLocations, SoyAutoescapeException e) {
        String message = "- " + e.getMessage();
        while (e.getCause() instanceof SoyAutoescapeException) {
            e = (SoyAutoescapeException)e.getCause();
            message = message + "\n- " + e.getMessage();
        }
        SourceLocation location = Preconditions.checkNotNull(e.getSourceLocation());
        if (errorLocations.contains(location)) {
            return;
        }
        errorLocations.add(location);
        errorReporter.report(location, AUTOESCAPE_ERROR, message);
    }

    private static Map<String, ImmutableList<TemplateNode>> findTemplates(Iterable<? extends SoyFileNode> files) {
        LinkedHashMap templatesByName = Maps.newLinkedHashMap();
        for (SoyFileNode soyFileNode : files) {
            for (TemplateNode template : soyFileNode.getChildren()) {
                String templateName = template instanceof TemplateBasicNode ? template.getTemplateName() : ((TemplateDelegateNode)template).getDelTemplateName();
                if (!templatesByName.containsKey(templateName)) {
                    templatesByName.put(templateName, ImmutableList.builder());
                }
                ((ImmutableList.Builder)templatesByName.get(templateName)).add(template);
            }
        }
        ImmutableMap.Builder templatesByNameBuilder = ImmutableMap.builder();
        for (Map.Entry e : templatesByName.entrySet()) {
            templatesByNameBuilder.put(e.getKey(), ((ImmutableList.Builder)e.getValue()).build());
        }
        return templatesByNameBuilder.build();
    }

    private static Map<String, SanitizedContent.ContentKind> makeOperatorKindMap(ImmutableMap<String, ? extends SoyPrintDirective> soyDirectivesMap) {
        ImmutableMap.Builder<String, SanitizedContent.ContentKind> operatorKindMapBuilder = ImmutableMap.builder();
        for (SoyPrintDirective directive : soyDirectivesMap.values()) {
            if (!(directive instanceof SanitizedContentOperator)) continue;
            operatorKindMapBuilder.put(directive.getName(), ((SanitizedContentOperator)((Object)directive)).getContentKind());
        }
        return operatorKindMapBuilder.build();
    }

    private final class NonContextualTypedRenderUnitNodesVisitor
    extends AbstractSoyNodeVisitor<Void> {
        final ErrorReporter errorReporter;

        NonContextualTypedRenderUnitNodesVisitor(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            if (node.getAutoescapeMode() == AutoescapeMode.NONCONTEXTUAL) {
                this.visitChildren(node);
            }
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitRenderUnitNode(node);
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitRenderUnitNode(node);
        }

        protected void visitRenderUnitNode(SoyNode.RenderUnitNode node) {
            if (node.getContentKind() != null) {
                ImmutableList.Builder<SlicedRawTextNode> slicedRawTextNodesBuilder = ImmutableList.builder();
                InferenceEngine.inferStrictRenderUnitNode(AutoescapeMode.NONCONTEXTUAL, node, ContextualAutoescaper.this.inferences, ContextualAutoescaper.this.autoescapeCancellingDirectives, slicedRawTextNodesBuilder, this.errorReporter);
            } else {
                this.visitChildren(node);
            }
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

