/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.LegacyInternalSyntaxException;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.AutoValue_TemplateDelegateNode_DelTemplateKey;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;

public final class TemplateDelegateNode
extends TemplateNode
implements SoyNode.ExprHolderNode {
    private final String delTemplateName;
    private String delTemplateVariant;
    private final ExprRootNode delTemplateVariantExpr;
    private DelTemplateKey delTemplateKey;
    private final TemplateNode.Priority delPriority;

    TemplateDelegateNode(TemplateDelegateNodeBuilder nodeBuilder, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String delTemplateName, String delTemplateVariant, ExprRootNode delTemplateVariantExpr, DelTemplateKey delTemplateKey, TemplateNode.Priority delPriority, ImmutableList<TemplateParam> params) {
        super(nodeBuilder, "deltemplate", soyFileHeaderInfo, Visibility.PUBLIC, params);
        this.delTemplateName = delTemplateName;
        this.delTemplateVariant = delTemplateVariant;
        this.delTemplateVariantExpr = delTemplateVariantExpr;
        this.delTemplateKey = delTemplateKey;
        this.delPriority = delPriority;
    }

    private TemplateDelegateNode(TemplateDelegateNode orig, CopyState copyState) {
        super(orig, copyState);
        this.delTemplateName = orig.delTemplateName;
        this.delTemplateVariant = orig.delTemplateVariant;
        this.delTemplateVariantExpr = orig.delTemplateVariantExpr;
        this.delTemplateKey = orig.delTemplateKey;
        this.delPriority = orig.delPriority;
    }

    static void verifyVariantName(String delTemplateVariant, SourceLocation srcLoc) {
        if (delTemplateVariant.length() > 0 && !BaseUtils.isIdentifier(delTemplateVariant)) {
            throw LegacyInternalSyntaxException.createWithMetaInfo("Invalid variant \"" + delTemplateVariant + "\" in 'deltemplate'" + " (when a string literal is used, value must be an identifier).", srcLoc);
        }
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_DELEGATE_NODE;
    }

    public String getDelTemplateName() {
        return this.delTemplateName;
    }

    public String getDelTemplateVariant() {
        if (this.delTemplateVariant != null) {
            return this.delTemplateVariant;
        }
        return this.resolveVariantExpression().variant();
    }

    public DelTemplateKey getDelTemplateKey() {
        if (this.delTemplateKey != null) {
            return this.delTemplateKey;
        }
        return this.resolveVariantExpression();
    }

    public TemplateNode.Priority getDelPriority() {
        return this.delPriority;
    }

    @Override
    public TemplateDelegateNode copy(CopyState copyState) {
        return new TemplateDelegateNode(this, copyState);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        if (this.delTemplateVariantExpr == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of(this.delTemplateVariantExpr);
    }

    private DelTemplateKey resolveVariantExpression() {
        if (this.delTemplateVariantExpr == null || this.delTemplateVariantExpr.numChildren() != 1) {
            throw this.invalidExpressionError();
        }
        ExprNode exprNode = this.delTemplateVariantExpr.getRoot();
        if (exprNode instanceof GlobalNode) {
            GlobalNode globalNode = (GlobalNode)exprNode;
            if (globalNode.isResolved()) {
                exprNode = globalNode.getValue();
            } else {
                return DelTemplateKey.create(this.delTemplateName, globalNode.getName());
            }
        }
        if (exprNode instanceof IntegerNode) {
            long variantValue = ((IntegerNode)exprNode).getValue();
            Preconditions.checkArgument(variantValue >= 0L, "Globals used as deltemplate variants must not evaluate to negative numbers.");
            this.delTemplateVariant = String.valueOf(variantValue);
            this.delTemplateKey = DelTemplateKey.create(this.delTemplateName, this.delTemplateVariant);
            return this.delTemplateKey;
        }
        if (exprNode instanceof StringNode) {
            this.delTemplateVariant = ((StringNode)exprNode).getValue();
            TemplateDelegateNode.verifyVariantName(this.delTemplateVariant, exprNode.getSourceLocation());
            this.delTemplateKey = DelTemplateKey.create(this.delTemplateName, this.delTemplateVariant);
            return this.delTemplateKey;
        }
        throw this.invalidExpressionError();
    }

    private AssertionError invalidExpressionError() {
        return new AssertionError((Object)("Invalid expression for deltemplate variant for " + this.delTemplateName + " template"));
    }

    public static abstract class DelTemplateKey {
        public static DelTemplateKey create(String name, String variant) {
            return new AutoValue_TemplateDelegateNode_DelTemplateKey(name, variant);
        }

        DelTemplateKey() {
        }

        public abstract String name();

        public abstract String variant();

        public String toString() {
            return this.name() + (this.variant().isEmpty() ? "" : ":" + this.variant());
        }
    }
}

