/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.errors;

import com.google.common.base.Joiner;
import com.google.common.escape.Escaper;
import java.util.ArrayList;
import java.util.List;
import org.parboiled.common.Formatter;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.matchers.AnyOfMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.support.Characters;
import org.parboiled.support.CharsEscaper;
import org.parboiled.support.MatcherPath;

public class DefaultInvalidInputErrorFormatter
implements Formatter<InvalidInputError> {
    private static final Escaper ESCAPER = CharsEscaper.INSTANCE;
    private static final Joiner JOINER = Joiner.on(", ");

    @Override
    public String format(InvalidInputError object) {
        if (object == null) {
            return "";
        }
        int len = object.getEndIndex() - object.getStartIndex();
        StringBuilder sb = new StringBuilder();
        if (len > 0) {
            char c = object.getInputBuffer().charAt(object.getStartIndex());
            if (c == '\uffff') {
                sb.append("Unexpected end of input");
            } else {
                sb.append("Invalid input '").append(ESCAPER.escape(String.valueOf(c)));
                if (len > 1) {
                    sb.append("...");
                }
                sb.append('\'');
            }
        } else {
            sb.append("Invalid input");
        }
        String expectedString = this.getExpectedString(object);
        if (!expectedString.isEmpty()) {
            sb.append(", expected ").append(expectedString);
        }
        return sb.toString();
    }

    public String getExpectedString(InvalidInputError error) {
        int pathStartIndex = error.getStartIndex() - error.getIndexDelta();
        ArrayList<String> labelList = new ArrayList<String>();
        for (MatcherPath path : error.getFailedMatchers()) {
            String[] labels;
            Matcher labelMatcher = ErrorUtils.findProperLabelMatcher(path, pathStartIndex);
            if (labelMatcher == null) continue;
            for (String label : labels = this.getLabels(labelMatcher)) {
                if (label == null || labelList.contains(label)) continue;
                labelList.add(label);
            }
        }
        return this.join(labelList);
    }

    public String[] getLabels(Matcher matcher) {
        String label = matcher.getLabel();
        String[] byDefault = new String[]{label};
        if (!(matcher instanceof AnyOfMatcher)) {
            return byDefault;
        }
        AnyOfMatcher anyOfMatcher = (AnyOfMatcher)matcher;
        Characters characters = anyOfMatcher.characters;
        if (!characters.toString().equals(label)) {
            return byDefault;
        }
        if (characters.isSubtractive()) {
            return byDefault;
        }
        String[] labels = new String[characters.getChars().length];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = '\'' + String.valueOf(characters.getChars()[i]) + '\'';
        }
        return labels;
    }

    public String join(List<String> labelList) {
        if (labelList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder("one of: [");
        JOINER.appendTo(sb, (Iterable<?>)labelList);
        sb.append(']');
        return ESCAPER.escape(sb.toString());
    }
}

