/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.auth.become;

import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gerrit.httpd.LoginUrlToken;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.httpd.template.SiteHeaderFooter;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.Accounts;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.AuthResult;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.query.account.InternalAccountQuery;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Singleton
class BecomeAnyAccountLoginServlet
extends HttpServlet {
    private final DynamicItem<WebSession> webSession;
    private final SchemaFactory<ReviewDb> schema;
    private final Accounts accounts;
    private final AccountCache accountCache;
    private final AccountManager accountManager;
    private final SiteHeaderFooter headers;
    private final Provider<InternalAccountQuery> queryProvider;

    @Inject
    BecomeAnyAccountLoginServlet(DynamicItem<WebSession> ws, SchemaFactory<ReviewDb> sf, Accounts a, AccountCache ac, AccountManager am, SiteHeaderFooter shf, Provider<InternalAccountQuery> qp) {
        this.webSession = ws;
        this.schema = sf;
        this.accounts = a;
        this.accountCache = ac;
        this.accountManager = am;
        this.headers = shf;
        this.queryProvider = qp;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException, ServletException {
        this.doPost(req, rsp);
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse rsp) throws IOException, ServletException {
        AuthResult res;
        CacheHeaders.setNotCacheable(rsp);
        if ("create_account".equals(req.getParameter("action"))) {
            res = this.create();
        } else if (req.getParameter("user_name") != null) {
            res = this.byUserName(req.getParameter("user_name"));
        } else if (req.getParameter("preferred_email") != null) {
            res = this.byPreferredEmail(req.getParameter("preferred_email"));
        } else if (req.getParameter("account_id") != null) {
            res = this.byAccountId(req.getParameter("account_id"));
        } else {
            byte[] raw;
            try {
                raw = this.prepareHtmlOutput();
            }
            catch (OrmException e) {
                throw new ServletException(e);
            }
            rsp.setContentType("text/html");
            rsp.setCharacterEncoding(HtmlDomUtil.ENC.name());
            rsp.setContentLength(raw.length);
            try (ServletOutputStream out = rsp.getOutputStream();){
                out.write(raw);
            }
            return;
        }
        if (res != null) {
            this.webSession.get().login(res, false);
            StringBuilder rdr = new StringBuilder();
            rdr.append(req.getContextPath());
            rdr.append("/");
            if (res.isNew()) {
                rdr.append("#/register");
            } else {
                rdr.append(LoginUrlToken.getToken(req));
            }
            rsp.sendRedirect(rdr.toString());
        } else {
            rsp.setContentType("text/html");
            rsp.setCharacterEncoding(HtmlDomUtil.ENC.name());
            try (PrintWriter out = rsp.getWriter();){
                ((Writer)out).write("<html>");
                ((Writer)out).write("<body>");
                ((Writer)out).write("<h1>Account Not Found</h1>");
                ((Writer)out).write("</body>");
                ((Writer)out).write("</html>");
            }
        }
    }

    private byte[] prepareHtmlOutput() throws IOException, OrmException {
        String pageName = "BecomeAnyAccount.html";
        Document doc = this.headers.parse(this.getClass(), "BecomeAnyAccount.html");
        if (doc == null) {
            throw new FileNotFoundException("No BecomeAnyAccount.html in webapp");
        }
        Element userlistElement = HtmlDomUtil.find(doc, "userlist");
        try (ReviewDb db = this.schema.open();){
            for (Account.Id accountId : this.accounts.firstNIds(100)) {
                Account a = this.accountCache.get(accountId).getAccount();
                String displayName = a.getUserName() != null ? a.getUserName() : (a.getFullName() != null && !a.getFullName().isEmpty() ? a.getFullName() : (a.getPreferredEmail() != null ? a.getPreferredEmail() : accountId.toString()));
                Element linkElement = doc.createElement("a");
                linkElement.setAttribute("href", "?account_id=" + a.getId().toString());
                linkElement.setTextContent(displayName);
                userlistElement.appendChild(linkElement);
                userlistElement.appendChild(doc.createElement("br"));
            }
        }
        return HtmlDomUtil.toUTF8(doc);
    }

    private AuthResult auth(Account account) {
        if (account != null) {
            return new AuthResult(account.getId(), null, false);
        }
        return null;
    }

    private AuthResult auth(Account.Id account) {
        if (account != null) {
            return new AuthResult(account, null, false);
        }
        return null;
    }

    private AuthResult byUserName(String userName) {
        try {
            List<AccountState> accountStates = this.queryProvider.get().byExternalId("username", userName);
            if (accountStates.isEmpty()) {
                this.getServletContext().log("No accounts with username " + userName + " found");
                return null;
            }
            if (accountStates.size() > 1) {
                this.getServletContext().log("Multiple accounts with username " + userName + " found");
                return null;
            }
            return this.auth(accountStates.get(0).getAccount().getId());
        }
        catch (OrmException e) {
            this.getServletContext().log("cannot query account index", e);
            return null;
        }
    }

    private AuthResult byPreferredEmail(String email) {
        AuthResult authResult;
        block8: {
            ReviewDb db = this.schema.open();
            Throwable throwable = null;
            try {
                Optional<Account> match = this.queryProvider.get().byPreferredEmail(email).stream().map(AccountState::getAccount).findFirst();
                AuthResult authResult2 = authResult = match.isPresent() ? this.auth(match.get()) : null;
                if (db == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (db != null) {
                            BecomeAnyAccountLoginServlet.$closeResource(throwable, db);
                        }
                        throw throwable3;
                    }
                }
                catch (OrmException e) {
                    this.getServletContext().log("cannot query database", e);
                    return null;
                }
            }
            BecomeAnyAccountLoginServlet.$closeResource(throwable, db);
        }
        return authResult;
    }

    private AuthResult byAccountId(String idStr) {
        Account.Id id;
        try {
            id = Account.Id.parse(idStr);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        try {
            return this.auth(this.accounts.get(id));
        }
        catch (IOException | ConfigInvalidException e) {
            this.getServletContext().log("cannot query database", e);
            return null;
        }
    }

    private AuthResult create() throws IOException {
        try {
            return this.accountManager.authenticate(new AuthRequest(ExternalId.Key.create("uuid", UUID.randomUUID().toString())));
        }
        catch (AccountException e) {
            this.getServletContext().log("cannot create new account", e);
            return null;
        }
    }
}

