/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.gitweb;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.GitwebCgiConfig;
import com.google.gerrit.server.config.GitwebConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LocalDiskRepositoryManager;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class GitwebServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GitwebServlet.class);
    private static final String PROJECT_LIST_ACTION = "project_list";
    private final Set<String> deniedActions;
    private final int bufferSize = 8192;
    private final Path gitwebCgi;
    private final URI gitwebUrl;
    private final LocalDiskRepositoryManager repoManager;
    private final ProjectCache projectCache;
    private final PermissionBackend permissionBackend;
    private final Provider<AnonymousUser> anonymousUserProvider;
    private final Provider<CurrentUser> userProvider;
    private final EnvList _env;

    @Inject
    GitwebServlet(GitRepositoryManager repoManager, ProjectCache projectCache, PermissionBackend permissionBackend, Provider<AnonymousUser> anonymousUserProvider, Provider<CurrentUser> userProvider, SitePaths site, @GerritServerConfig Config cfg, SshInfo sshInfo, GitwebConfig gitwebConfig, GitwebCgiConfig gitwebCgiConfig) throws IOException {
        String os;
        if (!(repoManager instanceof LocalDiskRepositoryManager)) {
            throw new ProvisionException("Gitweb can only be used with LocalDiskRepositoryManager");
        }
        this.repoManager = (LocalDiskRepositoryManager)repoManager;
        this.projectCache = projectCache;
        this.permissionBackend = permissionBackend;
        this.anonymousUserProvider = anonymousUserProvider;
        this.userProvider = userProvider;
        this.gitwebCgi = gitwebCgiConfig.getGitwebCgi();
        this.deniedActions = new HashSet<String>();
        String url = gitwebConfig.getUrl();
        if (url != null && !url.equals("gitweb")) {
            URI uri = null;
            try {
                uri = new URI(url);
            }
            catch (URISyntaxException e) {
                log.error("Invalid gitweb.url: {}", (Object)url);
            }
            this.gitwebUrl = uri;
        } else {
            this.gitwebUrl = null;
        }
        this.deniedActions.add("forks");
        this.deniedActions.add("opml");
        this.deniedActions.add("project_index");
        this._env = new EnvList();
        this.makeSiteConfig(site, cfg, sshInfo);
        if (!this._env.envMap.containsKey("SystemRoot") && (os = System.getProperty("os.name")) != null && os.toLowerCase().contains("windows")) {
            String sysroot = System.getenv("SystemRoot");
            if (sysroot == null || sysroot.isEmpty()) {
                sysroot = "C:\\WINDOWS";
            }
            this._env.set("SystemRoot", sysroot);
        }
        if (!this._env.envMap.containsKey("PATH")) {
            this._env.set("PATH", System.getenv("PATH"));
        }
    }

    private void makeSiteConfig(SitePaths site, Config cfg, SshInfo sshInfo) throws IOException {
        if (!Files.exists(site.tmp_dir, new LinkOption[0])) {
            Files.createDirectories(site.tmp_dir, new FileAttribute[0]);
        }
        Path myconf = Files.createTempFile(site.tmp_dir, "gitweb_config", ".perl", new FileAttribute[0]);
        File myconfFile = myconf.toFile();
        myconfFile.setWritable(false, false);
        myconfFile.setReadable(false, false);
        myconfFile.setExecutable(false, false);
        myconfFile.setWritable(true, true);
        myconfFile.setReadable(true, true);
        myconfFile.deleteOnExit();
        this._env.set("GIT_DIR", ".");
        this._env.set("GITWEB_CONFIG", myconf.toAbsolutePath().toString());
        try (PrintWriter p = new PrintWriter(Files.newBufferedWriter(myconf, StandardCharsets.UTF_8, new OpenOption[0]));){
            Path ftr;
            p.print("# Autogenerated by Gerrit Code Review \n");
            p.print("# DO NOT EDIT\n");
            p.print("\n");
            Path hdr = site.site_header;
            if (Files.isRegularFile(hdr, new LinkOption[0])) {
                p.print("$site_header = " + GitwebServlet.quoteForPerl(hdr) + ";\n");
            }
            if (Files.isRegularFile(ftr = site.site_footer, new LinkOption[0])) {
                p.print("$site_footer = " + GitwebServlet.quoteForPerl(ftr) + ";\n");
            }
            p.print("$home_link = $ENV{'GERRIT_CONTEXT_PATH'};\n");
            p.print("$home_link_str = 'Code Review';\n");
            p.print("$favicon = 'favicon.ico';\n");
            p.print("$logo = 'gitweb-logo.png';\n");
            p.print("$javascript = 'gitweb.js';\n");
            p.print("@stylesheets = ('gitweb-default.css');\n");
            Path css = site.site_css;
            if (Files.isRegularFile(css, new LinkOption[0])) {
                p.print("push @stylesheets, 'gitweb-site.css';\n");
            }
            p.print("$site_name = $home_link_str;\n");
            p.print("$site_name = qq{$1 $site_name} if ");
            p.print("$ENV{'SERVER_NAME'} =~ m,^([^.]+(?:\\.[^.]+)?)(?:\\.|$),;\n");
            p.print("$prevent_xss = 1;\n");
            p.print("{\n");
            p.print("  my $secure = $ENV{'HTTPS'} =~ /^ON$/i;\n");
            p.print("  my $http_url = $secure ? 'https://' : 'http://';\n");
            p.print("  $http_url .= qq{$ENV{'GERRIT_USER_NAME'}@}\n");
            p.print("    unless $ENV{'GERRIT_ANONYMOUS_READ'};\n");
            p.print("  $http_url .= $ENV{'SERVER_NAME'};\n");
            p.print("  $http_url .= qq{:$ENV{'SERVER_PORT'}}\n");
            p.print("    if (( $secure && $ENV{'SERVER_PORT'} != 443)\n");
            p.print("     || (!$secure && $ENV{'SERVER_PORT'} != 80)\n");
            p.print("    );\n");
            p.print("  my $context = $ENV{'GERRIT_CONTEXT_PATH'};\n");
            p.print("  chop($context);\n");
            p.print("  $http_url .= qq{$context};\n");
            p.print("  $http_url .= qq{/a}\n");
            p.print("    unless $ENV{'GERRIT_ANONYMOUS_READ'};\n");
            p.print("  push @git_base_url_list, $http_url;\n");
            p.print("}\n");
            String url = cfg.getString("gerrit", null, "canonicalGitUrl");
            if (url != null) {
                if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                p.print("if ($ENV{'GERRIT_ANONYMOUS_READ'}) {\n");
                p.print("  push @git_base_url_list, ");
                p.print(GitwebServlet.quoteForPerl(url));
                p.print(";\n");
                p.print("}\n");
            }
            if (sshInfo != null && !sshInfo.getHostKeys().isEmpty()) {
                String sshAddr = sshInfo.getHostKeys().get(0).getHost();
                p.print("if ($ENV{'GERRIT_USER_NAME'}) {\n");
                p.print("  push @git_base_url_list, join('', 'ssh://'");
                p.print(", $ENV{'GERRIT_USER_NAME'}");
                p.print(", '@'");
                if (sshAddr.startsWith("*:") || "".equals(sshAddr)) {
                    p.print(", $ENV{'SERVER_NAME'}");
                }
                if (sshAddr.startsWith("*")) {
                    sshAddr = sshAddr.substring(1);
                }
                p.print(", " + GitwebServlet.quoteForPerl(sshAddr));
                p.print(");\n");
                p.print("}\n");
            }
            p.print("sub add_review_link {\n");
            p.print("  my $h = shift;\n");
            p.print("  my $q;\n");
            p.print("  if (!$h || $h eq 'HEAD') {\n");
            p.print("    $q = qq{#/q/project:$ENV{'GERRIT_PROJECT_NAME'}};\n");
            p.print("  } elsif ($h =~ /^refs\\/heads\\/([-\\w]+)$/) {\n");
            p.print("    $q = qq{#/q/project:$ENV{'GERRIT_PROJECT_NAME'}");
            p.print("+branch:$1};\n");
            p.print("  } elsif ($h =~ /^refs\\/changes\\/\\d{2}\\/(\\d+)\\/\\d+$/) ");
            p.print("{\n");
            p.print("    $q = qq{#/c/$1};\n");
            p.print("  } else {\n");
            p.print("    $q = qq{#/q/$h};\n");
            p.print("  }\n");
            p.print("  my $r = qq{$ENV{'GERRIT_CONTEXT_PATH'}$q};\n");
            p.print("  push @{$feature{'actions'}{'default'}},\n");
            p.print("      ('review',$r,'commitdiff');\n");
            p.print("}\n");
            p.print("if ($cgi->param('hb')) {\n");
            p.print("  add_review_link(scalar $cgi->param('hb'));\n");
            p.print("} elsif ($cgi->param('h')) {\n");
            p.print("  add_review_link(scalar $cgi->param('h'));\n");
            p.print("} else {\n");
            p.print("  add_review_link();\n");
            p.print("}\n");
            Path sitecfg = site.site_gitweb;
            if (Files.isRegularFile(sitecfg, new LinkOption[0])) {
                p.print("$GITWEB_CONFIG = " + GitwebServlet.quoteForPerl(sitecfg) + ";\n");
                p.print("if (-e $GITWEB_CONFIG) {\n");
                p.print("  do " + GitwebServlet.quoteForPerl(sitecfg) + ";\n");
                p.print("}\n");
            }
            p.print("$projectroot = $ENV{'GITWEB_PROJECTROOT'};\n");
            p.print("$export_auth_hook = sub {\n");
            p.print("    my $dir = shift;\n");
            p.print("    my $name = $ENV{'GERRIT_PROJECT_NAME'};\n");
            p.print("    my $allow = qq{$projectroot/$name.git};\n");
            p.print("    return $dir eq $allow;\n");
            p.print("  };\n");
            p.print("$feature{'pathinfo'}{'override'} = 0;\n");
            p.print("$feature{'pathinfo'}{'default'} = [0];\n");
            p.print("$feature{'forks'}{'override'} = 0;\n");
            p.print("$feature{'forks'}{'default'} = [0];\n");
        }
        myconfFile.setReadOnly();
    }

    private static String quoteForPerl(Path value) {
        return GitwebServlet.quoteForPerl(value.toAbsolutePath().toString());
    }

    private static String quoteForPerl(String value) {
        if (value == null || value.isEmpty()) {
            return "''";
        }
        if (!value.contains("'")) {
            return "'" + value + "'";
        }
        if (!value.contains("{") && !value.contains("}")) {
            return "q{" + value + "}";
        }
        throw new IllegalArgumentException("Cannot quote in Perl: " + value);
    }

    @Override
    protected void service(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        String name;
        if (req.getQueryString() == null || req.getQueryString().isEmpty()) {
            rsp.sendRedirect(req.getContextPath() + "/");
            return;
        }
        Map<String, String> params = GitwebServlet.getParameters(req);
        String a = params.get("a");
        if (a != null) {
            if (this.deniedActions.contains(a)) {
                rsp.sendError(403);
                return;
            }
            if (a.equals(PROJECT_LIST_ACTION)) {
                rsp.sendRedirect(req.getContextPath() + "/#" + "/admin/projects/" + "?filter=" + Url.encode(params.get("pf") + "/"));
                return;
            }
        }
        if ((name = params.get("p")) == null) {
            rsp.sendError(404);
            return;
        }
        if (name.endsWith(".git")) {
            name = name.substring(0, name.length() - 4);
        }
        Project.NameKey nameKey = new Project.NameKey(name);
        try {
            if (this.projectCache.checkedGet(nameKey) == null) {
                this.notFound(req, rsp);
                return;
            }
            this.permissionBackend.user(this.userProvider).project(nameKey).check(ProjectPermission.READ);
        }
        catch (AuthException e) {
            this.notFound(req, rsp);
            return;
        }
        catch (PermissionBackendException | IOException err) {
            log.error("cannot load " + name, err);
            rsp.sendError(500);
            return;
        }
        try (Repository repo = this.repoManager.openRepository(nameKey);){
            CacheHeaders.setNotCacheable(rsp);
            this.exec(req, rsp, nameKey);
        }
        catch (RepositoryNotFoundException e) {
            this.getServletContext().log("Cannot open repository", e);
            rsp.sendError(500);
        }
    }

    private void notFound(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        if (this.userProvider.get().isIdentifiedUser()) {
            rsp.sendError(404);
        } else {
            rsp.sendRedirect(GitwebServlet.getLoginRedirectUrl(req));
        }
    }

    private static String getLoginRedirectUrl(HttpServletRequest req) {
        String queryString;
        String contextPath = req.getContextPath();
        String loginUrl = contextPath + "/login/";
        String token = req.getRequestURI();
        if (!contextPath.isEmpty()) {
            token = token.substring(contextPath.length());
        }
        if ((queryString = req.getQueryString()) != null && !queryString.isEmpty()) {
            token = token.concat("?" + queryString);
        }
        return loginUrl + Url.encode(token);
    }

    private static Map<String, String> getParameters(HttpServletRequest req) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String pair : req.getQueryString().split("[&;]")) {
            int eq = pair.indexOf(61);
            if (0 >= eq) continue;
            String name = pair.substring(0, eq);
            String value = pair.substring(eq + 1);
            name = Url.decode(name);
            value = Url.decode(value);
            params.put(name, value);
        }
        return params;
    }

    private void exec(HttpServletRequest req, HttpServletResponse rsp, Project.NameKey project) throws IOException {
        Process proc = Runtime.getRuntime().exec(new String[]{this.gitwebCgi.toAbsolutePath().toString()}, this.makeEnv(req, project), this.gitwebCgi.toAbsolutePath().getParent().toFile());
        this.copyStderrToLog(proc.getErrorStream());
        if (0 < req.getContentLength()) {
            this.copyContentToCGI(req, proc.getOutputStream());
        } else {
            proc.getOutputStream().close();
        }
        try (BufferedInputStream in = new BufferedInputStream(proc.getInputStream(), 8192);){
            this.readCgiHeaders(rsp, in);
            try (ServletOutputStream out = rsp.getOutputStream();){
                int n;
                byte[] buf = new byte[8192];
                while ((n = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, n);
                }
            }
        }
        catch (IOException e) {
            proc.destroy();
            return;
        }
        try {
            proc.waitFor();
            int status = proc.exitValue();
            if (0 != status) {
                log.error("Non-zero exit status ({}) from {}", (Object)status, (Object)this.gitwebCgi);
                if (!rsp.isCommitted()) {
                    rsp.sendError(500);
                }
            }
        }
        catch (InterruptedException ie) {
            log.debug("CGI: interrupted waiting for CGI to terminate");
        }
    }

    private String[] makeEnv(HttpServletRequest req, Project.NameKey nameKey) {
        EnvList env = new EnvList(this._env);
        int contentLength = Math.max(0, req.getContentLength());
        env.set("AUTH_TYPE", req.getAuthType());
        env.set("CONTENT_LENGTH", Integer.toString(contentLength));
        env.set("CONTENT_TYPE", req.getContentType());
        env.set("GATEWAY_INTERFACE", "CGI/1.1");
        env.set("PATH_INFO", req.getPathInfo());
        env.set("PATH_TRANSLATED", null);
        env.set("QUERY_STRING", req.getQueryString());
        env.set("REMOTE_ADDR", req.getRemoteAddr());
        env.set("REMOTE_HOST", req.getRemoteHost());
        env.set("HTTPS", req.isSecure() ? "ON" : "OFF");
        env.set("REQUEST_METHOD", req.getMethod());
        env.set("SCRIPT_NAME", req.getContextPath() + req.getServletPath());
        env.set("SCRIPT_FILENAME", this.gitwebCgi.toAbsolutePath().toString());
        env.set("SERVER_NAME", req.getServerName());
        env.set("SERVER_PORT", Integer.toString(req.getServerPort()));
        env.set("SERVER_PROTOCOL", req.getProtocol());
        env.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
        Enumeration<String> hdrs = GitwebServlet.enumerateHeaderNames(req);
        while (hdrs.hasMoreElements()) {
            String name = hdrs.nextElement();
            String value = req.getHeader(name);
            env.set("HTTP_" + name.toUpperCase().replace('-', '_'), value);
        }
        env.set("GERRIT_CONTEXT_PATH", req.getContextPath() + "/");
        env.set("GERRIT_PROJECT_NAME", nameKey.get());
        env.set("GITWEB_PROJECTROOT", this.repoManager.getBasePath(nameKey).toAbsolutePath().toString());
        if (this.permissionBackend.user(this.anonymousUserProvider).project(nameKey).testOrFalse(ProjectPermission.READ)) {
            env.set("GERRIT_ANONYMOUS_READ", "1");
        }
        String remoteUser = null;
        if (this.userProvider.get().isIdentifiedUser()) {
            IdentifiedUser u = this.userProvider.get().asIdentifiedUser();
            String user = u.getUserName();
            env.set("GERRIT_USER_NAME", user);
            remoteUser = user != null && !user.isEmpty() ? user : "account-" + u.getAccountId();
        }
        env.set("REMOTE_USER", remoteUser);
        if (this.gitwebUrl != null) {
            int schemePort = -1;
            if (this.gitwebUrl.getScheme() != null) {
                if (this.gitwebUrl.getScheme().equals("http")) {
                    env.set("HTTPS", "OFF");
                    schemePort = 80;
                } else {
                    env.set("HTTPS", "ON");
                    schemePort = 443;
                }
            }
            if (this.gitwebUrl.getHost() != null) {
                env.set("SERVER_NAME", this.gitwebUrl.getHost());
                env.set("HTTP_HOST", this.gitwebUrl.getHost());
            }
            if (this.gitwebUrl.getPort() != -1) {
                env.set("SERVER_PORT", Integer.toString(this.gitwebUrl.getPort()));
            } else if (schemePort != -1) {
                env.set("SERVER_PORT", Integer.toString(schemePort));
            }
            if (this.gitwebUrl.getPath() != null) {
                env.set("SCRIPT_NAME", this.gitwebUrl.getPath().isEmpty() ? "/" : this.gitwebUrl.getPath());
            }
        }
        return env.getEnvArray();
    }

    private void copyContentToCGI(HttpServletRequest req, OutputStream dst) throws IOException {
        int contentLength = req.getContentLength();
        ServletInputStream src = req.getInputStream();
        new Thread(() -> {
            try {
                try {
                    int n;
                    byte[] buf = new byte[8192];
                    for (int remaining = contentLength; 0 < remaining; remaining -= n) {
                        int max = Math.max(buf.length, remaining);
                        n = src.read(buf, 0, max);
                        if (n < 0) {
                            throw new EOFException("Expected " + remaining + " more bytes");
                        }
                        dst.write(buf, 0, n);
                    }
                }
                finally {
                    dst.close();
                }
            }
            catch (IOException e) {
                log.error("Unexpected error copying input to CGI", e);
            }
        }, "Gitweb-InputFeeder").start();
    }

    private void copyStderrToLog(InputStream in) {
        new Thread(() -> {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(in, StandardCharsets.ISO_8859_1.name()));
                Throwable throwable = null;
                try {
                    String err = br.lines().filter(s -> !s.isEmpty()).map(s -> "CGI: " + s).collect(Collectors.joining("\n")).trim();
                    if (!err.isEmpty()) {
                        log.error(err);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    GitwebServlet.$closeResource(throwable, br);
                }
            }
            catch (IOException e) {
                log.error("Unexpected error copying stderr from CGI", e);
            }
        }, "Gitweb-ErrorLogger").start();
    }

    private static Enumeration<String> enumerateHeaderNames(HttpServletRequest req) {
        return req.getHeaderNames();
    }

    private void readCgiHeaders(HttpServletResponse res, InputStream in) throws IOException {
        String line;
        while (!(line = this.readLine(in)).isEmpty()) {
            if (line.startsWith("HTTP")) {
                throw new IOException("NPH CGI not supported: " + line);
            }
            int sep = line.indexOf(58);
            if (sep < 0) {
                throw new IOException("CGI returned invalid header: " + line);
            }
            String key = line.substring(0, sep).trim();
            String value = line.substring(sep + 1).trim();
            if ("Location".equalsIgnoreCase(key)) {
                res.sendRedirect(value);
                continue;
            }
            if ("Status".equalsIgnoreCase(key)) {
                String[] token = value.split(" ");
                int status = Integer.parseInt(token[0]);
                res.setStatus(status);
                continue;
            }
            res.addHeader(key, value);
        }
    }

    private String readLine(InputStream in) throws IOException {
        int b;
        StringBuilder buf = new StringBuilder();
        while ((b = in.read()) != -1 && b != 10) {
            buf.append((char)b);
        }
        return buf.toString().trim();
    }

    private static class EnvList {
        private Map<String, String> envMap;

        EnvList() {
            this.envMap = new HashMap<String, String>();
        }

        EnvList(EnvList l) {
            this.envMap = new HashMap<String, String>(l.envMap);
        }

        public void set(String name, String value) {
            if (value == null) {
                value = "";
            }
            this.envMap.put(name, name + "=" + value);
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }

        public String toString() {
            return this.envMap.toString();
        }
    }
}

