/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.gerrit.httpd.HtmlDomUtil;
import com.google.gwtexpui.server.CacheHeaders;
import com.google.gwtjsonrpc.server.RPCServletUtils;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class LegacyGerritServlet
extends HttpServlet {
    private final byte[] raw;
    private final byte[] compressed;

    @Inject
    LegacyGerritServlet() throws IOException {
        String pageName = "LegacyGerrit.html";
        String doc = HtmlDomUtil.readFile(this.getClass(), "LegacyGerrit.html");
        if (doc == null) {
            throw new FileNotFoundException("No LegacyGerrit.html in webapp");
        }
        this.raw = doc.getBytes(HtmlDomUtil.ENC);
        this.compressed = HtmlDomUtil.compress(this.raw);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        byte[] tosend;
        if (RPCServletUtils.acceptsGzipEncoding(req)) {
            rsp.setHeader("Content-Encoding", "gzip");
            tosend = this.compressed;
        } else {
            tosend = this.raw;
        }
        CacheHeaders.setNotCacheable(rsp);
        rsp.setContentType("text/html");
        rsp.setCharacterEncoding(HtmlDomUtil.ENC.name());
        rsp.setContentLength(tosend.length);
        try (ServletOutputStream out = rsp.getOutputStream();){
            out.write(tosend);
        }
    }
}

