/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.pgm.init.api;

import com.google.gerrit.pgm.init.api.AllUsersNameOnInitProvider;
import com.google.gerrit.pgm.init.api.GitRepositoryManagerOnInit;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.RepoSequence;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class SequencesOnInit {
    private final GitRepositoryManager repoManager;
    private final AllUsersNameOnInitProvider allUsersName;

    @Inject
    SequencesOnInit(GitRepositoryManagerOnInit repoManager, AllUsersNameOnInitProvider allUsersName) {
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
    }

    public int nextAccountId(ReviewDb db) throws OrmException {
        RepoSequence.Seed accountSeed = () -> db.nextAccountId();
        RepoSequence accountSeq = new RepoSequence(this.repoManager, GitReferenceUpdated.DISABLED, new Project.NameKey(this.allUsersName.get()), "accounts", accountSeed, 1);
        return accountSeq.next();
    }
}

