/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.gerrit.server.ModuleImpl;
import com.google.inject.Module;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ModuleOverloader {
    public static List<Module> override(List<Module> modules, List<Module> overrideCandidates) {
        List<Module> overrides;
        if (overrideCandidates == null || overrideCandidates.isEmpty()) {
            return modules;
        }
        Map<Boolean, List<Module>> grouped = overrideCandidates.stream().collect(Collectors.groupingBy(m -> m.getClass().getAnnotation(ModuleImpl.class) != null));
        List<Module> libs = grouped.get(Boolean.FALSE);
        if (libs != null) {
            modules.addAll(libs);
        }
        if ((overrides = grouped.get(Boolean.TRUE)) == null) {
            return modules;
        }
        return modules.stream().map(m -> {
            ModuleImpl a = m.getClass().getAnnotation(ModuleImpl.class);
            if (a == null) {
                return m;
            }
            return overrides.stream().filter(o -> o.getClass().getAnnotation(ModuleImpl.class).name().equalsIgnoreCase(a.name())).findFirst().orElse((Module)m);
        }).collect(Collectors.toList());
    }

    private ModuleOverloader() {
    }
}

