/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.client.AccountFieldName;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.mail.send.EmailSender;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractRealm
implements Realm {
    private EmailSender emailSender;

    @Inject(optional=true)
    void setEmailSender(EmailSender emailSender) {
        this.emailSender = emailSender;
    }

    @Override
    public Set<AccountFieldName> getEditableFields() {
        HashSet<AccountFieldName> fields = new HashSet<AccountFieldName>();
        for (AccountFieldName n : AccountFieldName.values()) {
            if (!this.allowsEdit(n)) continue;
            if (n == AccountFieldName.REGISTER_NEW_EMAIL) {
                if (this.emailSender == null || !this.emailSender.isEnabled()) continue;
                fields.add(n);
                continue;
            }
            fields.add(n);
        }
        return fields;
    }

    @Override
    public boolean hasEmailAddress(IdentifiedUser user, String email) {
        for (ExternalId ext : user.state().getExternalIds()) {
            if (email == null || !email.equalsIgnoreCase(ext.email())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getEmailAddresses(IdentifiedUser user) {
        Collection<ExternalId> ids = user.state().getExternalIds();
        HashSet<String> emails = Sets.newHashSetWithExpectedSize(ids.size());
        for (ExternalId ext : ids) {
            if (Strings.isNullOrEmpty(ext.email())) continue;
            emails.add(ext.email());
        }
        return emails;
    }
}

