/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.data.GlobalCapability;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityCollection;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;

public class AccountLimits {
    private final CapabilityCollection capabilities;
    private final CurrentUser user;

    private AccountLimits(ProjectCache projectCache, CurrentUser currentUser) {
        this.capabilities = projectCache.getAllProjects().getCapabilityCollection();
        this.user = currentUser;
    }

    public QueueProvider.QueueType getQueueType() {
        GroupMembership groups = this.user.getEffectiveGroups();
        boolean batch = false;
        for (PermissionRule r : this.capabilities.priority) {
            if (!AccountLimits.match(groups, r)) continue;
            switch (r.getAction()) {
                case INTERACTIVE: {
                    if (SystemGroupBackend.isAnonymousOrRegistered(r.getGroup())) break;
                    return QueueProvider.QueueType.INTERACTIVE;
                }
                case BATCH: {
                    batch = true;
                    break;
                }
            }
        }
        if (batch) {
            return QueueProvider.QueueType.BATCH;
        }
        return QueueProvider.QueueType.INTERACTIVE;
    }

    public int getQueryLimit() {
        return this.getRange("queryLimit").getMax();
    }

    public boolean hasExplicitRange(String permission) {
        return GlobalCapability.hasRange(permission) && !this.getRules(permission).isEmpty();
    }

    public PermissionRange getRange(String permission) {
        if (GlobalCapability.hasRange(permission)) {
            return AccountLimits.toRange(permission, this.getRules(permission));
        }
        return null;
    }

    private static PermissionRange toRange(String permissionName, List<PermissionRule> ruleList) {
        int min = 0;
        int max = 0;
        if (ruleList.isEmpty()) {
            PermissionRange.WithDefaults defaultRange = GlobalCapability.getRange(permissionName);
            if (defaultRange != null) {
                min = defaultRange.getDefaultMin();
                max = defaultRange.getDefaultMax();
            }
        } else {
            for (PermissionRule rule : ruleList) {
                min = Math.min(min, rule.getMin());
                max = Math.max(max, rule.getMax());
            }
        }
        return new PermissionRange(permissionName, min, max);
    }

    private List<PermissionRule> getRules(String permissionName) {
        ImmutableList<PermissionRule> rules = this.capabilities.getPermission(permissionName);
        GroupMembership groups = this.user.getEffectiveGroups();
        ArrayList<PermissionRule> mine = new ArrayList<PermissionRule>(rules.size());
        for (PermissionRule rule : rules) {
            if (!AccountLimits.match(groups, rule)) continue;
            mine.add(rule);
        }
        return mine;
    }

    private static boolean match(GroupMembership groups, PermissionRule rule) {
        return groups.contains(rule.getGroup().getUUID());
    }

    @Singleton
    public static class Factory {
        private final ProjectCache projectCache;

        @Inject
        Factory(ProjectCache projectCache) {
            this.projectCache = projectCache;
        }

        public AccountLimits create(CurrentUser user) {
            return new AccountLimits(this.projectCache, user);
        }
    }
}

