/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.account.AccountDirectory;
import com.google.gerrit.server.account.InternalAccountDirectory;
import com.google.gwtorm.server.OrmException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AccountLoader {
    public static final Set<AccountDirectory.FillOptions> DETAILED_OPTIONS = Collections.unmodifiableSet(EnumSet.of(AccountDirectory.FillOptions.ID, new AccountDirectory.FillOptions[]{AccountDirectory.FillOptions.NAME, AccountDirectory.FillOptions.EMAIL, AccountDirectory.FillOptions.USERNAME, AccountDirectory.FillOptions.STATUS, AccountDirectory.FillOptions.AVATARS}));
    private final InternalAccountDirectory directory;
    private final Set<AccountDirectory.FillOptions> options;
    private final Map<Account.Id, AccountInfo> created;
    private final List<AccountInfo> provided;

    @AssistedInject
    AccountLoader(InternalAccountDirectory directory, @Assisted boolean detailed) {
        this(directory, detailed ? DETAILED_OPTIONS : InternalAccountDirectory.ID_ONLY);
    }

    @AssistedInject
    AccountLoader(InternalAccountDirectory directory, @Assisted Set<AccountDirectory.FillOptions> options) {
        this.directory = directory;
        this.options = options;
        this.created = new HashMap<Account.Id, AccountInfo>();
        this.provided = new ArrayList<AccountInfo>();
    }

    public AccountInfo get(Account.Id id) {
        if (id == null) {
            return null;
        }
        AccountInfo info = this.created.get(id);
        if (info == null) {
            info = new AccountInfo(id.get());
            this.created.put(id, info);
        }
        return info;
    }

    public void put(AccountInfo info) {
        Preconditions.checkArgument(info._accountId != null, "_accountId field required");
        this.provided.add(info);
    }

    public void fill() throws OrmException {
        try {
            this.directory.fillAccountInfo(Iterables.concat(this.created.values(), this.provided), this.options);
        }
        catch (AccountDirectory.DirectoryException e) {
            Throwables.throwIfInstanceOf(e.getCause(), OrmException.class);
            throw new OrmException(e);
        }
    }

    public void fill(Collection<? extends AccountInfo> infos) throws OrmException {
        for (AccountInfo accountInfo : infos) {
            this.put(accountInfo);
        }
        this.fill();
    }

    public AccountInfo fillOne(Account.Id id) throws OrmException {
        AccountInfo info = this.get(id);
        this.fill();
        return info;
    }

    public static interface Factory {
        public AccountLoader create(boolean var1);

        public AccountLoader create(Set<AccountDirectory.FillOptions> var1);
    }
}

