/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.SetInactiveFlag;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;

@RequiresCapability(value="modifyAccount")
@Singleton
public class DeleteActive
implements RestModifyView<AccountResource, Input> {
    private final Provider<IdentifiedUser> self;
    private final SetInactiveFlag setInactiveFlag;

    @Inject
    DeleteActive(SetInactiveFlag setInactiveFlag, Provider<IdentifiedUser> self) {
        this.setInactiveFlag = setInactiveFlag;
        this.self = self;
    }

    public Response<?> apply(AccountResource rsrc, Input input) throws RestApiException, OrmException, IOException, ConfigInvalidException {
        if (this.self.get().hasSameAccountId(rsrc.getUser())) {
            throw new ResourceConflictException("cannot deactivate own account");
        }
        return this.setInactiveFlag.deactivate(rsrc.getUser().getAccountId());
    }

    public static class Input {
    }
}

