/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.group.InternalGroupDescription;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Optional;

public class GroupControl {
    private final CurrentUser user;
    private final GroupDescription.Basic group;
    private Boolean isOwner;
    private final PermissionBackend.WithUser perm;
    private final GroupBackend groupBackend;

    GroupControl(CurrentUser who, GroupDescription.Basic gd, PermissionBackend permissionBackend, GroupBackend gb) {
        this.user = who;
        this.group = gd;
        this.perm = permissionBackend.user(this.user);
        this.groupBackend = gb;
    }

    public GroupDescription.Basic getGroup() {
        return this.group;
    }

    public CurrentUser getUser() {
        return this.user;
    }

    public boolean isVisible() {
        return this.user.isInternalUser() || this.groupBackend.isVisibleToAll(this.group.getGroupUUID()) || this.user.getEffectiveGroups().contains(this.group.getGroupUUID()) || this.isOwner() || this.canAdministrateServer();
    }

    public boolean isOwner() {
        if (this.isOwner != null) {
            return this.isOwner;
        }
        if (this.group instanceof GroupDescription.Internal) {
            AccountGroup.UUID ownerUUID = ((GroupDescription.Internal)this.group).getOwnerGroupUUID();
            this.isOwner = this.getUser().getEffectiveGroups().contains(ownerUUID) || this.canAdministrateServer();
        } else {
            this.isOwner = false;
        }
        return this.isOwner;
    }

    private boolean canAdministrateServer() {
        try {
            this.perm.check(GlobalPermission.ADMINISTRATE_SERVER);
            return true;
        }
        catch (AuthException | PermissionBackendException denied) {
            return false;
        }
    }

    public boolean canAddMember() {
        return this.isOwner();
    }

    public boolean canRemoveMember() {
        return this.isOwner();
    }

    public boolean canSeeMember(Account.Id id) {
        if (this.user.isIdentifiedUser() && this.user.getAccountId().equals(id)) {
            return true;
        }
        return this.canSeeMembers();
    }

    public boolean canAddGroup() {
        return this.isOwner();
    }

    public boolean canRemoveGroup() {
        return this.isOwner();
    }

    public boolean canSeeGroup() {
        return this.canSeeMembers();
    }

    private boolean canSeeMembers() {
        if (this.group instanceof GroupDescription.Internal) {
            return ((GroupDescription.Internal)this.group).isVisibleToAll() || this.isOwner();
        }
        return false;
    }

    public static class Factory {
        private final PermissionBackend permissionBackend;
        private final GroupCache groupCache;
        private final Provider<CurrentUser> user;
        private final GroupBackend groupBackend;

        @Inject
        Factory(PermissionBackend permissionBackend, GroupCache gc, Provider<CurrentUser> cu, GroupBackend gb) {
            this.permissionBackend = permissionBackend;
            this.groupCache = gc;
            this.user = cu;
            this.groupBackend = gb;
        }

        public GroupControl controlFor(AccountGroup.Id groupId) throws NoSuchGroupException {
            Optional<InternalGroup> group = this.groupCache.get(groupId);
            return group.map(InternalGroupDescription::new).map(this::controlFor).orElseThrow(() -> new NoSuchGroupException(groupId));
        }

        public GroupControl controlFor(AccountGroup.UUID groupId) throws NoSuchGroupException {
            GroupDescription.Basic group = this.groupBackend.get(groupId);
            if (group == null) {
                throw new NoSuchGroupException(groupId);
            }
            return this.controlFor(group);
        }

        public GroupControl controlFor(AccountGroup group) {
            return this.controlFor(GroupDescriptions.forAccountGroup(group));
        }

        public GroupControl controlFor(GroupDescription.Basic group) {
            return new GroupControl(this.user.get(), group, this.permissionBackend, this.groupBackend);
        }

        public GroupControl validateFor(AccountGroup.UUID groupUUID) throws NoSuchGroupException {
            GroupControl c = this.controlFor(groupUUID);
            if (!c.isVisible()) {
                throw new NoSuchGroupException(groupUUID);
            }
            return c;
        }
    }

    @Singleton
    public static class GenericFactory {
        private final PermissionBackend permissionBackend;
        private final GroupBackend groupBackend;

        @Inject
        GenericFactory(PermissionBackend permissionBackend, GroupBackend gb) {
            this.permissionBackend = permissionBackend;
            this.groupBackend = gb;
        }

        public GroupControl controlFor(CurrentUser who, AccountGroup.UUID groupId) throws NoSuchGroupException {
            GroupDescription.Basic group = this.groupBackend.get(groupId);
            if (group == null) {
                throw new NoSuchGroupException(groupId);
            }
            return new GroupControl(who, group, this.permissionBackend, this.groupBackend);
        }
    }
}

