/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.externalids.ExternalId;
import com.google.gerrit.server.account.externalids.ExternalIds;
import com.google.gerrit.server.account.externalids.ExternalIdsUpdate;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.jgit.errors.ConfigInvalidException;

public class PutHttpPassword
implements RestModifyView<AccountResource, Input> {
    private static final int LEN = 31;
    private static final SecureRandom rng;
    private final Provider<CurrentUser> self;
    private final PermissionBackend permissionBackend;
    private final ExternalIds externalIds;
    private final ExternalIdsUpdate.User externalIdsUpdate;

    @Inject
    PutHttpPassword(Provider<CurrentUser> self, PermissionBackend permissionBackend, ExternalIds externalIds, ExternalIdsUpdate.User externalIdsUpdate) {
        this.self = self;
        this.permissionBackend = permissionBackend;
        this.externalIds = externalIds;
        this.externalIdsUpdate = externalIdsUpdate;
    }

    public Response<String> apply(AccountResource rsrc, Input input) throws AuthException, ResourceNotFoundException, ResourceConflictException, OrmException, IOException, ConfigInvalidException, PermissionBackendException {
        String newPassword;
        if (!this.self.get().hasSameAccountId(rsrc.getUser())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.ADMINISTRATE_SERVER);
        }
        if (input == null) {
            input = new Input();
        }
        input.httpPassword = Strings.emptyToNull(input.httpPassword);
        if (input.generate) {
            newPassword = PutHttpPassword.generate();
        } else if (input.httpPassword == null) {
            newPassword = null;
        } else {
            this.permissionBackend.user(this.self).check(GlobalPermission.ADMINISTRATE_SERVER);
            newPassword = input.httpPassword;
        }
        return this.apply(rsrc.getUser(), newPassword);
    }

    public Response<String> apply(IdentifiedUser user, String newPassword) throws ResourceNotFoundException, ResourceConflictException, OrmException, IOException, ConfigInvalidException {
        if (user.getUserName() == null) {
            throw new ResourceConflictException("username must be set");
        }
        ExternalId extId = this.externalIds.get(ExternalId.Key.create("username", user.getUserName()));
        if (extId == null) {
            throw new ResourceNotFoundException();
        }
        ExternalId newExtId = ExternalId.createWithPassword(extId.key(), extId.accountId(), extId.email(), newPassword);
        this.externalIdsUpdate.create().upsert(newExtId);
        return Strings.isNullOrEmpty(newPassword) ? Response.none() : Response.ok(newPassword);
    }

    public static String generate() {
        byte[] rand = new byte[31];
        rng.nextBytes(rand);
        byte[] enc = Base64.encodeBase64(rand, false);
        StringBuilder r = new StringBuilder(enc.length);
        for (int i = 0; i < enc.length && enc[i] != 61; ++i) {
            r.append((char)enc[i]);
        }
        return r.toString();
    }

    static {
        try {
            rng = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot create RNG for password generator", e);
        }
    }

    public static class Input {
        public String httpPassword;
        public boolean generate;
    }
}

