/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.gerrit.extensions.api.changes.CommentApi;
import com.google.gerrit.extensions.api.changes.DeleteCommentInput;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.change.CommentResource;
import com.google.gerrit.server.change.DeleteComment;
import com.google.gerrit.server.change.GetComment;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

class CommentApiImpl
implements CommentApi {
    private final GetComment getComment;
    private final DeleteComment deleteComment;
    private final CommentResource comment;

    @Inject
    CommentApiImpl(GetComment getComment, DeleteComment deleteComment, @Assisted CommentResource comment) {
        this.getComment = getComment;
        this.deleteComment = deleteComment;
        this.comment = comment;
    }

    @Override
    public CommentInfo get() throws RestApiException {
        try {
            return this.getComment.apply(this.comment);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve comment", e);
        }
    }

    @Override
    public CommentInfo delete(DeleteCommentInput input) throws RestApiException {
        try {
            return (CommentInfo)this.deleteComment.apply(this.comment, input);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot delete comment", e);
        }
    }

    static interface Factory {
        public CommentApiImpl create(CommentResource var1);
    }
}

