/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.projects;

import com.google.gerrit.extensions.api.changes.ChangeApi;
import com.google.gerrit.extensions.api.changes.Changes;
import com.google.gerrit.extensions.api.changes.CherryPickInput;
import com.google.gerrit.extensions.api.projects.CommitApi;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.change.CherryPickCommit;
import com.google.gerrit.server.project.CommitResource;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class CommitApiImpl
implements CommitApi {
    private final Changes changes;
    private final CherryPickCommit cherryPickCommit;
    private final CommitResource commitResource;

    @Inject
    CommitApiImpl(Changes changes, CherryPickCommit cherryPickCommit, @Assisted CommitResource commitResource) {
        this.changes = changes;
        this.cherryPickCommit = cherryPickCommit;
        this.commitResource = commitResource;
    }

    @Override
    public ChangeApi cherryPick(CherryPickInput input) throws RestApiException {
        try {
            return this.changes.id(((ChangeInfo)this.cherryPickCommit.apply(this.commitResource, input))._number);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot cherry pick", e);
        }
    }

    public static interface Factory {
        public CommitApiImpl create(CommitResource var1);
    }
}

