/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.api.changes.DeleteCommentInput;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.CommentJson;
import com.google.gerrit.server.change.CommentResource;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class DeleteComment
extends RetryingRestModifyView<CommentResource, DeleteCommentInput, CommentInfo> {
    private final Provider<CurrentUser> userProvider;
    private final Provider<ReviewDb> dbProvider;
    private final PermissionBackend permissionBackend;
    private final CommentsUtil commentsUtil;
    private final Provider<CommentJson> commentJson;
    private final ChangeNotes.Factory notesFactory;

    @Inject
    public DeleteComment(Provider<CurrentUser> userProvider, Provider<ReviewDb> dbProvider, PermissionBackend permissionBackend, RetryHelper retryHelper, CommentsUtil commentsUtil, Provider<CommentJson> commentJson, ChangeNotes.Factory notesFactory) {
        super(retryHelper);
        this.userProvider = userProvider;
        this.dbProvider = dbProvider;
        this.permissionBackend = permissionBackend;
        this.commentsUtil = commentsUtil;
        this.commentJson = commentJson;
        this.notesFactory = notesFactory;
    }

    @Override
    public CommentInfo applyImpl(BatchUpdate.Factory batchUpdateFactory, CommentResource rsrc, DeleteCommentInput input) throws RestApiException, IOException, ConfigInvalidException, OrmException, PermissionBackendException, UpdateException {
        CurrentUser user = this.userProvider.get();
        this.permissionBackend.user(user).check(GlobalPermission.ADMINISTRATE_SERVER);
        if (input == null) {
            input = new DeleteCommentInput();
        }
        String newMessage = DeleteComment.getCommentNewMessage(user.asIdentifiedUser().getName(), input.reason);
        DeleteCommentOp deleteCommentOp = new DeleteCommentOp(rsrc, newMessage);
        try (BatchUpdate batchUpdate = batchUpdateFactory.create(this.dbProvider.get(), rsrc.getRevisionResource().getProject(), user, TimeUtil.nowTs());){
            batchUpdate.addOp(rsrc.getRevisionResource().getChange().getId(), deleteCommentOp).execute();
        }
        ChangeNotes updatedNotes = this.notesFactory.createChecked(rsrc.getRevisionResource().getChange().getId());
        List<Comment> changeComments = this.commentsUtil.publishedByChange(this.dbProvider.get(), updatedNotes);
        Optional<Comment> updatedComment = changeComments.stream().filter(c -> c.key.equals(rsrc.getComment().key)).findFirst();
        if (!updatedComment.isPresent()) {
            throw new ResourceNotFoundException("comment not found: " + rsrc.getComment().key);
        }
        return this.commentJson.get().newCommentFormatter().format(updatedComment.get());
    }

    private static String getCommentNewMessage(String name, String reason) {
        StringBuilder stringBuilder = new StringBuilder("Comment removed by: ").append(name);
        if (!Strings.isNullOrEmpty(reason)) {
            stringBuilder.append("; Reason: ").append(reason);
        }
        return stringBuilder.toString();
    }

    private class DeleteCommentOp
    implements BatchUpdateOp {
        private final CommentResource rsrc;
        private final String newMessage;

        DeleteCommentOp(CommentResource rsrc, String newMessage) {
            this.rsrc = rsrc;
            this.newMessage = newMessage;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws ResourceConflictException, OrmException, ResourceNotFoundException {
            PatchSet.Id psId = ctx.getChange().currentPatchSetId();
            DeleteComment.this.commentsUtil.deleteCommentByRewritingHistory(ctx.getDb(), ctx.getUpdate(psId), this.rsrc.getComment().key, this.rsrc.getPatchSet().getId(), this.newMessage);
            return true;
        }
    }
}

