/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.extensions.api.changes.MoveInput;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.conditions.BooleanCondition;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.LabelId;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.RefPermission;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class Move
extends RetryingRestModifyView<ChangeResource, MoveInput, ChangeInfo>
implements UiAction<ChangeResource> {
    private final PermissionBackend permissionBackend;
    private final Provider<ReviewDb> dbProvider;
    private final ChangeJson.Factory json;
    private final GitRepositoryManager repoManager;
    private final Provider<InternalChangeQuery> queryProvider;
    private final ChangeMessagesUtil cmUtil;
    private final PatchSetUtil psUtil;
    private final ApprovalsUtil approvalsUtil;
    private final ProjectCache projectCache;
    private final Provider<CurrentUser> userProvider;

    @Inject
    Move(PermissionBackend permissionBackend, Provider<ReviewDb> dbProvider, ChangeJson.Factory json, GitRepositoryManager repoManager, Provider<InternalChangeQuery> queryProvider, ChangeMessagesUtil cmUtil, RetryHelper retryHelper, PatchSetUtil psUtil, ApprovalsUtil approvalsUtil, ProjectCache projectCache, Provider<CurrentUser> userProvider) {
        super(retryHelper);
        this.permissionBackend = permissionBackend;
        this.dbProvider = dbProvider;
        this.json = json;
        this.repoManager = repoManager;
        this.queryProvider = queryProvider;
        this.cmUtil = cmUtil;
        this.psUtil = psUtil;
        this.approvalsUtil = approvalsUtil;
        this.projectCache = projectCache;
        this.userProvider = userProvider;
    }

    @Override
    protected ChangeInfo applyImpl(BatchUpdate.Factory updateFactory, ChangeResource rsrc, MoveInput input) throws RestApiException, OrmException, UpdateException, PermissionBackendException {
        Change change = rsrc.getChange();
        Project.NameKey project = rsrc.getProject();
        IdentifiedUser caller = rsrc.getUser().asIdentifiedUser();
        if (input.destinationBranch == null) {
            throw new BadRequestException("destination branch is required");
        }
        input.destinationBranch = RefNames.fullName(input.destinationBranch);
        if (change.getStatus().isClosed()) {
            throw new ResourceConflictException("Change is " + ChangeUtil.status(change));
        }
        Branch.NameKey newDest = new Branch.NameKey(project, input.destinationBranch);
        if (change.getDest().equals(newDest)) {
            throw new ResourceConflictException("Change is already destined for the specified branch");
        }
        try {
            ((PermissionBackend.ForChange)rsrc.permissions().database(this.dbProvider)).check(ChangePermission.ABANDON);
            ((PermissionBackend.WithUser)this.permissionBackend.user(caller).database(this.dbProvider)).ref(newDest).check(RefPermission.CREATE_CHANGE);
        }
        catch (AuthException denied) {
            throw new AuthException("move not permitted", denied);
        }
        Op op = new Op(input);
        try (BatchUpdate u = updateFactory.create(this.dbProvider.get(), project, caller, TimeUtil.nowTs());){
            u.addOp(change.getId(), op);
            u.execute();
        }
        return this.json.noOptions().format(op.getChange());
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        Change change = rsrc.getChange();
        return new UiAction.Description().setLabel("Move Change").setTitle("Move change to a different branch").setVisible(BooleanCondition.and(change.getStatus().isOpen(), BooleanCondition.and(this.permissionBackend.user(rsrc.getUser()).ref(change.getDest()).testCond(RefPermission.CREATE_CHANGE), ((PermissionBackend.ForChange)rsrc.permissions().database(this.dbProvider)).testCond(ChangePermission.ABANDON))));
    }

    private class Op
    implements BatchUpdateOp {
        private final MoveInput input;
        private Change change;
        private Branch.NameKey newDestKey;

        Op(MoveInput input) {
            this.input = input;
        }

        @Nullable
        public Change getChange() {
            return this.change;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws OrmException, ResourceConflictException, IOException {
            this.change = ctx.getChange();
            if (this.change.getStatus() != Change.Status.NEW) {
                throw new ResourceConflictException("Change is " + ChangeUtil.status(this.change));
            }
            Project.NameKey projectKey = this.change.getProject();
            this.newDestKey = new Branch.NameKey(projectKey, this.input.destinationBranch);
            Branch.NameKey changePrevDest = this.change.getDest();
            if (changePrevDest.equals(this.newDestKey)) {
                throw new ResourceConflictException("Change is already destined for the specified branch");
            }
            PatchSet.Id patchSetId = this.change.currentPatchSetId();
            try (Repository repo = Move.this.repoManager.openRepository(projectKey);
                 RevWalk revWalk = new RevWalk(repo);){
                RevCommit currPatchsetRevCommit = revWalk.parseCommit(ObjectId.fromString(Move.this.psUtil.current(ctx.getDb(), ctx.getNotes()).getRevision().get()));
                if (currPatchsetRevCommit.getParentCount() > 1) {
                    throw new ResourceConflictException("Merge commit cannot be moved");
                }
                ObjectId refId = repo.resolve(this.input.destinationBranch);
                if (refId == null) {
                    throw new ResourceConflictException("Destination " + this.input.destinationBranch + " not found in the project");
                }
                RevCommit refCommit = revWalk.parseCommit(refId);
                if (revWalk.isMergedInto(currPatchsetRevCommit, refCommit)) {
                    throw new ResourceConflictException("Current patchset revision is reachable from tip of " + this.input.destinationBranch);
                }
            }
            Change.Key changeKey = this.change.getKey();
            if (!ChangeData.asChanges(((InternalChangeQuery)Move.this.queryProvider.get()).byBranchKey(this.newDestKey, changeKey)).isEmpty()) {
                throw new ResourceConflictException("Destination " + this.newDestKey.getShortName() + " has a different change with same change key " + changeKey);
            }
            if (!this.change.currentPatchSetId().equals(patchSetId)) {
                throw new ResourceConflictException("Patch set is not current");
            }
            PatchSet.Id psId = this.change.currentPatchSetId();
            ChangeUpdate update = ctx.getUpdate(psId);
            update.setBranch(this.newDestKey.get());
            this.change.setDest(this.newDestKey);
            this.updateApprovals(ctx, update, psId, projectKey);
            StringBuilder msgBuf = new StringBuilder();
            msgBuf.append("Change destination moved from ");
            msgBuf.append(changePrevDest.getShortName());
            msgBuf.append(" to ");
            msgBuf.append(this.newDestKey.getShortName());
            if (!Strings.isNullOrEmpty(this.input.message)) {
                msgBuf.append("\n\n");
                msgBuf.append(this.input.message);
            }
            ChangeMessage cmsg = ChangeMessagesUtil.newMessage(ctx, msgBuf.toString(), "autogenerated:gerrit:move");
            Move.this.cmUtil.addChangeMessage(ctx.getDb(), update, cmsg);
            return true;
        }

        private void updateApprovals(ChangeContext ctx, ChangeUpdate update, PatchSet.Id psId, Project.NameKey project) throws IOException, OrmException {
            ArrayList<PatchSetApproval> approvals = new ArrayList<PatchSetApproval>();
            for (PatchSetApproval psa : Move.this.approvalsUtil.byPatchSet(ctx.getDb(), ctx.getNotes(), (CurrentUser)Move.this.userProvider.get(), psId, ctx.getRevWalk(), ctx.getRepoView().getConfig())) {
                ProjectState projectState = Move.this.projectCache.checkedGet(project);
                LabelType type = projectState.getLabelTypes(ctx.getNotes(), ctx.getUser()).byLabel(psa.getLabelId());
                if (type == null || type.isMaxNegative(psa) && type.getFunction().isBlock()) continue;
                update.removeApprovalFor(psa.getAccountId(), psa.getLabel());
                approvals.add(new PatchSetApproval(new PatchSetApproval.Key(psId, psa.getAccountId(), new LabelId(psa.getLabel())), 0, ctx.getWhen()));
            }
            ctx.getDb().patchSetApprovals().upsert(approvals);
        }
    }
}

