/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.extensions.events.PrivateStateChanged;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;

public class SetPrivateOp
implements BatchUpdateOp {
    private final ChangeMessagesUtil cmUtil;
    private final PatchSetUtil psUtil;
    private final boolean isPrivate;
    private final Input input;
    private final PrivateStateChanged privateStateChanged;
    private Change change;
    private PatchSet ps;

    @Inject
    SetPrivateOp(PrivateStateChanged privateStateChanged, PatchSetUtil psUtil, @Assisted ChangeMessagesUtil cmUtil, @Assisted boolean isPrivate, @Assisted Input input) {
        this.cmUtil = cmUtil;
        this.psUtil = psUtil;
        this.isPrivate = isPrivate;
        this.input = input;
        this.privateStateChanged = privateStateChanged;
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws ResourceConflictException, OrmException {
        this.change = ctx.getChange();
        ChangeNotes notes = ctx.getNotes();
        this.ps = this.psUtil.get(ctx.getDb(), notes, this.change.currentPatchSetId());
        ChangeUpdate update = ctx.getUpdate(this.change.currentPatchSetId());
        this.change.setPrivate(this.isPrivate);
        this.change.setLastUpdatedOn(ctx.getWhen());
        update.setPrivate(this.isPrivate);
        this.addMessage(ctx, update);
        return true;
    }

    @Override
    public void postUpdate(Context ctx) {
        this.privateStateChanged.fire(this.change, this.ps, ctx.getAccount(), ctx.getWhen());
    }

    private void addMessage(ChangeContext ctx, ChangeUpdate update) throws OrmException {
        Change c = ctx.getChange();
        StringBuilder buf = new StringBuilder(c.isPrivate() ? "Set private" : "Unset private");
        String m = Strings.nullToEmpty(this.input == null ? null : this.input.message).trim();
        if (!m.isEmpty()) {
            buf.append("\n\n");
            buf.append(m);
        }
        ChangeMessage cmsg = ChangeMessagesUtil.newMessage(ctx, buf.toString(), c.isPrivate() ? "autogenerated:gerrit:setPrivate" : "autogenerated:gerrit:unsetPrivate");
        this.cmUtil.addChangeMessage(ctx.getDb(), update, cmsg);
    }

    public static interface Factory {
        public SetPrivateOp create(ChangeMessagesUtil var1, boolean var2, Input var3);
    }

    public static class Input {
        String message;

        public Input() {
        }

        public Input(String message) {
            this.message = message;
        }
    }
}

