/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.server.config.RequestScopedReviewDbProvider;
import com.google.gerrit.server.util.RequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestScopePropagator;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;

public class PerThreadRequestScope {
    private static final ThreadLocal<Context> current = new ThreadLocal();
    public static final Scope REQUEST = new Scope(){

        @Override
        public <T> Provider<T> scope(final Key<T> key, final Provider<T> creator) {
            return new Provider<T>(){

                @Override
                public T get() {
                    return PerThreadRequestScope.requireContext().get(key, creator);
                }

                public String toString() {
                    return String.format("%s[%s]", creator, REQUEST);
                }
            };
        }

        @Override
        public String toString() {
            return "PerThreadRequestScope.REQUEST";
        }
    };

    private static Context requireContext() {
        Context ctx = current.get();
        if (ctx == null) {
            throw new OutOfScopeException("Not in command/request");
        }
        return ctx;
    }

    public static class Propagator
    extends ThreadLocalRequestScopePropagator<Context> {
        @Inject
        Propagator(ThreadLocalRequestContext local, Provider<RequestScopedReviewDbProvider> dbProviderProvider) {
            super(REQUEST, current, local, dbProviderProvider);
        }

        @Override
        protected Context continuingContext(Context ctx) {
            return new Context();
        }

        public <T> Callable<T> scope(RequestContext requestContext, Callable<T> callable) {
            Context ctx = new Context();
            Callable wrapped = this.context(requestContext, this.cleanup(callable));
            return () -> {
                Context old = (Context)current.get();
                current.set(ctx);
                try {
                    Object v = wrapped.call();
                    return v;
                }
                finally {
                    current.set(old);
                }
            };
        }
    }

    private static class Context {
        private final Map<Key<?>, Object> map = new HashMap();

        private Context() {
        }

        private <T> T get(Key<T> key, Provider<T> creator) {
            Object t = this.map.get(key);
            if (t == null) {
                t = creator.get();
                this.map.put(key, t);
            }
            return (T)t;
        }
    }

    public static interface Scoper {
        public <T> Callable<T> scope(Callable<T> var1);
    }
}

