/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.server.git.RefCache;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;

public class RepoRefCache
implements RefCache {
    private final RefDatabase refdb;
    private final Map<String, Optional<ObjectId>> ids;

    public RepoRefCache(Repository repo) {
        this.refdb = repo.getRefDatabase();
        this.ids = new HashMap<String, Optional<ObjectId>>();
    }

    @Override
    public Optional<ObjectId> get(String refName) throws IOException {
        Optional<ObjectId> id = this.ids.get(refName);
        if (id != null) {
            return id;
        }
        Ref ref = this.refdb.exactRef(refName);
        id = Optional.ofNullable(ref).map(Ref::getObjectId);
        this.ids.put(refName, id);
        return id;
    }

    public Map<String, Optional<ObjectId>> getCachedRefs() {
        return Collections.unmodifiableMap(this.ids);
    }
}

