/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.GroupAuditEventInfo;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupByIdAud;
import com.google.gerrit.reviewdb.client.AccountGroupMemberAudit;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.group.InternalGroupDescription;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

@Singleton
public class GetAuditLog
implements RestReadView<GroupResource> {
    private final Provider<ReviewDb> db;
    private final AccountLoader.Factory accountLoaderFactory;
    private final GroupCache groupCache;
    private final GroupJson groupJson;
    private final GroupBackend groupBackend;

    @Inject
    public GetAuditLog(Provider<ReviewDb> db, AccountLoader.Factory accountLoaderFactory, GroupCache groupCache, GroupJson groupJson, GroupBackend groupBackend) {
        this.db = db;
        this.accountLoaderFactory = accountLoaderFactory;
        this.groupCache = groupCache;
        this.groupJson = groupJson;
        this.groupBackend = groupBackend;
    }

    public List<? extends GroupAuditEventInfo> apply(GroupResource rsrc) throws AuthException, MethodNotAllowedException, OrmException {
        GroupDescription.Internal group = rsrc.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        if (!rsrc.getControl().isOwner()) {
            throw new AuthException("Not group owner");
        }
        AccountLoader accountLoader = this.accountLoaderFactory.create(true);
        ArrayList<GroupAuditEventInfo> auditEvents = new ArrayList<GroupAuditEventInfo>();
        for (AccountGroupMemberAudit accountGroupMemberAudit : this.db.get().accountGroupMembersAudit().byGroup(group.getId()).toList()) {
            AccountInfo member = accountLoader.get(accountGroupMemberAudit.getKey().getParentKey());
            auditEvents.add(GroupAuditEventInfo.createAddUserEvent(accountLoader.get(accountGroupMemberAudit.getAddedBy()), accountGroupMemberAudit.getKey().getAddedOn(), member));
            if (accountGroupMemberAudit.isActive()) continue;
            auditEvents.add(GroupAuditEventInfo.createRemoveUserEvent(accountLoader.get(accountGroupMemberAudit.getRemovedBy()), accountGroupMemberAudit.getRemovedOn(), member));
        }
        for (AccountGroupByIdAud accountGroupByIdAud : this.db.get().accountGroupByIdAud().byGroup(group.getId()).toList()) {
            GroupInfo member;
            AccountGroup.UUID includedGroupUUID = accountGroupByIdAud.getKey().getIncludeUUID();
            Optional<InternalGroup> includedGroup = this.groupCache.get(includedGroupUUID);
            if (includedGroup.isPresent()) {
                member = this.groupJson.format(new InternalGroupDescription(includedGroup.get()));
            } else {
                GroupDescription.Basic groupDescription = this.groupBackend.get(includedGroupUUID);
                member = new GroupInfo();
                member.id = Url.encode(includedGroupUUID.get());
                if (groupDescription != null) {
                    member.name = groupDescription.getName();
                }
            }
            auditEvents.add(GroupAuditEventInfo.createAddGroupEvent(accountLoader.get(accountGroupByIdAud.getAddedBy()), accountGroupByIdAud.getKey().getAddedOn(), member));
            if (accountGroupByIdAud.isActive()) continue;
            auditEvents.add(GroupAuditEventInfo.createRemoveGroupEvent(accountLoader.get(accountGroupByIdAud.getRemovedBy()), accountGroupByIdAud.getRemovedOn(), member));
        }
        accountLoader.fill();
        Collections.sort(auditEvents, new Comparator<GroupAuditEventInfo>(){

            @Override
            public int compare(GroupAuditEventInfo e1, GroupAuditEventInfo e2) {
                return e2.date.compareTo(e1.date);
            }
        });
        return auditEvents;
    }
}

