/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupDescriptions;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.client.ListGroupsOption;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetGroups;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.group.GroupJson;
import com.google.gerrit.server.group.Groups;
import com.google.gerrit.server.group.InternalGroupDescription;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.kohsuke.args4j.Option;

public class ListGroups
implements RestReadView<TopLevelResource> {
    private static final Comparator<GroupDescription.Internal> GROUP_COMPARATOR = Comparator.comparing(GroupDescription.Basic::getName);
    protected final GroupCache groupCache;
    private final List<ProjectControl> projects = new ArrayList<ProjectControl>();
    private final Set<AccountGroup.UUID> groupsToInspect = new HashSet<AccountGroup.UUID>();
    private final GroupControl.Factory groupControlFactory;
    private final GroupControl.GenericFactory genericGroupControlFactory;
    private final Provider<IdentifiedUser> identifiedUser;
    private final IdentifiedUser.GenericFactory userFactory;
    private final GetGroups accountGetGroups;
    private final GroupJson json;
    private final GroupBackend groupBackend;
    private final Groups groups;
    private final Provider<ReviewDb> db;
    private EnumSet<ListGroupsOption> options = EnumSet.noneOf(ListGroupsOption.class);
    private boolean visibleToAll;
    private Account.Id user;
    private boolean owned;
    private int limit;
    private int start;
    private String matchSubstring;
    private String matchRegex;
    private String suggest;

    @Option(name="--project", aliases={"-p"}, usage="projects for which the groups should be listed")
    public void addProject(ProjectControl project) {
        this.projects.add(project);
    }

    @Option(name="--visible-to-all", usage="to list only groups that are visible to all registered users")
    public void setVisibleToAll(boolean visibleToAll) {
        this.visibleToAll = visibleToAll;
    }

    @Option(name="--user", aliases={"-u"}, usage="user for which the groups should be listed")
    public void setUser(Account.Id user) {
        this.user = user;
    }

    @Option(name="--owned", usage="to list only groups that are owned by the specified user or by the calling user if no user was specifed")
    public void setOwned(boolean owned) {
        this.owned = owned;
    }

    @Deprecated
    @Option(name="--query", aliases={"-q"}, usage="group to inspect (deprecated: use --group/-g instead)")
    void addGroup_Deprecated(AccountGroup.UUID uuid) {
        this.addGroup(uuid);
    }

    @Option(name="--group", aliases={"-g"}, usage="group to inspect")
    public void addGroup(AccountGroup.UUID uuid) {
        this.groupsToInspect.add(uuid);
    }

    @Option(name="--limit", aliases={"-n"}, metaVar="CNT", usage="maximum number of groups to list")
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Option(name="--start", aliases={"-S"}, metaVar="CNT", usage="number of groups to skip")
    public void setStart(int start) {
        this.start = start;
    }

    @Option(name="--match", aliases={"-m"}, metaVar="MATCH", usage="match group substring")
    public void setMatchSubstring(String matchSubstring) {
        this.matchSubstring = matchSubstring;
    }

    @Option(name="--regex", aliases={"-r"}, metaVar="REGEX", usage="match group regex")
    public void setMatchRegex(String matchRegex) {
        this.matchRegex = matchRegex;
    }

    @Option(name="--suggest", aliases={"-s"}, usage="to get a suggestion of groups")
    public void setSuggest(String suggest) {
        this.suggest = suggest;
    }

    @Option(name="-o", usage="Output options per group")
    void addOption(ListGroupsOption o) {
        this.options.add(o);
    }

    @Option(name="-O", usage="Output option flags, in hex")
    void setOptionFlagsHex(String hex) {
        this.options.addAll(ListGroupsOption.fromBits(Integer.parseInt(hex, 16)));
    }

    @Inject
    protected ListGroups(GroupCache groupCache, GroupControl.Factory groupControlFactory, GroupControl.GenericFactory genericGroupControlFactory, Provider<IdentifiedUser> identifiedUser, IdentifiedUser.GenericFactory userFactory, GetGroups accountGetGroups, GroupJson json, GroupBackend groupBackend, Groups groups, Provider<ReviewDb> db) {
        this.groupCache = groupCache;
        this.groupControlFactory = groupControlFactory;
        this.genericGroupControlFactory = genericGroupControlFactory;
        this.identifiedUser = identifiedUser;
        this.userFactory = userFactory;
        this.accountGetGroups = accountGetGroups;
        this.json = json;
        this.groupBackend = groupBackend;
        this.groups = groups;
        this.db = db;
    }

    public void setOptions(EnumSet<ListGroupsOption> options) {
        this.options = options;
    }

    public Account.Id getUser() {
        return this.user;
    }

    public List<ProjectControl> getProjects() {
        return this.projects;
    }

    public SortedMap<String, GroupInfo> apply(TopLevelResource resource) throws OrmException, BadRequestException {
        TreeMap<String, GroupInfo> output = new TreeMap<String, GroupInfo>();
        for (GroupInfo info : this.get()) {
            output.put(MoreObjects.firstNonNull(info.name, "Group " + Url.decode(info.id)), info);
            info.name = null;
        }
        return output;
    }

    public List<GroupInfo> get() throws OrmException, BadRequestException {
        if (!Strings.isNullOrEmpty(this.suggest)) {
            return this.suggestGroups();
        }
        if (!Strings.isNullOrEmpty(this.matchSubstring) && !Strings.isNullOrEmpty(this.matchRegex)) {
            throw new BadRequestException("Specify one of m/r");
        }
        if (this.owned) {
            return this.getGroupsOwnedBy(this.user != null ? this.userFactory.create(this.user) : this.identifiedUser.get());
        }
        if (this.user != null) {
            return this.accountGetGroups.apply(new AccountResource(this.userFactory.create(this.user)));
        }
        return this.getAllGroups();
    }

    private List<GroupInfo> getAllGroups() throws OrmException {
        Pattern pattern = this.getRegexPattern();
        Stream<GroupDescription.Internal> existingGroups = this.getAllExistingGroups().filter(group -> !this.isNotRelevant(pattern, (GroupDescription.Internal)group)).sorted(GROUP_COMPARATOR).skip(this.start);
        if (this.limit > 0) {
            existingGroups = existingGroups.limit(this.limit);
        }
        List relevantGroups = existingGroups.collect(ImmutableList.toImmutableList());
        ArrayList<GroupInfo> groupInfos = Lists.newArrayListWithCapacity(relevantGroups.size());
        for (GroupDescription.Internal group2 : relevantGroups) {
            groupInfos.add(this.json.addOptions(this.options).format(group2));
        }
        return groupInfos;
    }

    private Stream<GroupDescription.Internal> getAllExistingGroups() throws OrmException {
        if (!this.projects.isEmpty()) {
            return this.projects.stream().map(ProjectControl::getProjectState).map(ProjectState::getAllGroups).flatMap(Collection::stream).map(GroupReference::getUUID).distinct().map(this.groupCache::get).flatMap(Streams::stream).map(InternalGroupDescription::new);
        }
        return this.groups.getAll(this.db.get()).map(GroupDescriptions::forAccountGroup);
    }

    private List<GroupInfo> suggestGroups() throws OrmException, BadRequestException {
        if (this.conflictingSuggestParameters()) {
            throw new BadRequestException("You should only have no more than one --project and -n with --suggest");
        }
        ArrayList<GroupReference> groupRefs = Lists.newArrayList(Iterables.limit(this.groupBackend.suggest(this.suggest, this.projects.stream().findFirst().map(pc -> pc.getProjectState()).orElse(null)), this.limit <= 0 ? 10 : Math.min(this.limit, 10)));
        ArrayList<GroupInfo> groupInfos = Lists.newArrayListWithCapacity(groupRefs.size());
        for (GroupReference ref : groupRefs) {
            GroupDescription.Basic desc = this.groupBackend.get(ref.getUUID());
            if (desc == null) continue;
            groupInfos.add(this.json.addOptions(this.options).format(desc));
        }
        return groupInfos;
    }

    private boolean conflictingSuggestParameters() {
        if (Strings.isNullOrEmpty(this.suggest)) {
            return false;
        }
        if (this.projects.size() > 1) {
            return true;
        }
        if (this.visibleToAll) {
            return true;
        }
        if (this.user != null) {
            return true;
        }
        if (this.owned) {
            return true;
        }
        if (this.start != 0) {
            return true;
        }
        if (!this.groupsToInspect.isEmpty()) {
            return true;
        }
        if (!Strings.isNullOrEmpty(this.matchSubstring)) {
            return true;
        }
        return !Strings.isNullOrEmpty(this.matchRegex);
    }

    private List<GroupInfo> getGroupsOwnedBy(IdentifiedUser user) throws OrmException {
        Pattern pattern = this.getRegexPattern();
        Stream<GroupDescription.Internal> foundGroups = this.groups.getAll(this.db.get()).map(GroupDescriptions::forAccountGroup).filter(group -> !this.isNotRelevant(pattern, (GroupDescription.Internal)group)).filter(group -> this.isOwner(user, (GroupDescription.Internal)group)).sorted(GROUP_COMPARATOR).skip(this.start);
        if (this.limit > 0) {
            foundGroups = foundGroups.limit(this.limit);
        }
        List ownedGroups = foundGroups.collect(ImmutableList.toImmutableList());
        ArrayList<GroupInfo> groupInfos = new ArrayList<GroupInfo>(ownedGroups.size());
        for (GroupDescription.Internal group2 : ownedGroups) {
            groupInfos.add(this.json.addOptions(this.options).format(group2));
        }
        return groupInfos;
    }

    private boolean isOwner(CurrentUser user, GroupDescription.Internal group) {
        try {
            return this.genericGroupControlFactory.controlFor(user, group.getGroupUUID()).isOwner();
        }
        catch (NoSuchGroupException e) {
            return false;
        }
    }

    private Pattern getRegexPattern() {
        return Strings.isNullOrEmpty(this.matchRegex) ? null : Pattern.compile(this.matchRegex);
    }

    private boolean isNotRelevant(Pattern pattern, GroupDescription.Internal group) {
        if (!Strings.isNullOrEmpty(this.matchSubstring) ? !group.getName().toLowerCase(Locale.US).contains(this.matchSubstring.toLowerCase(Locale.US)) : pattern != null && !pattern.matcher(group.getName()).matches()) {
            return true;
        }
        if (this.visibleToAll && !group.isVisibleToAll()) {
            return true;
        }
        if (!this.groupsToInspect.isEmpty() && !this.groupsToInspect.contains(group.getGroupUUID())) {
            return true;
        }
        GroupControl c = this.groupControlFactory.controlFor(group);
        return !c.isVisible();
    }
}

