/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.api.accounts.AccountInfoComparator;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.InternalGroup;
import com.google.gerrit.server.group.InternalGroupDescription;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.kohsuke.args4j.Option;

public class ListMembers
implements RestReadView<GroupResource> {
    private final GroupCache groupCache;
    private final GroupControl.Factory groupControlFactory;
    private final AccountLoader accountLoader;
    @Option(name="--recursive", usage="to resolve included groups recursively")
    private boolean recursive;

    @Inject
    protected ListMembers(GroupCache groupCache, GroupControl.Factory groupControlFactory, AccountLoader.Factory accountLoaderFactory) {
        this.groupCache = groupCache;
        this.groupControlFactory = groupControlFactory;
        this.accountLoader = accountLoaderFactory.create(true);
    }

    public ListMembers setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public List<AccountInfo> apply(GroupResource resource) throws MethodNotAllowedException, OrmException {
        GroupDescription.Internal group = resource.asInternalGroup().orElseThrow(MethodNotAllowedException::new);
        return this.apply(group.getGroupUUID());
    }

    public List<AccountInfo> apply(AccountGroup.UUID groupId) throws OrmException {
        Set<Account.Id> members = this.getMembers(groupId, new HashSet<AccountGroup.UUID>());
        ArrayList<AccountInfo> memberInfos = new ArrayList<AccountInfo>(members.size());
        for (Account.Id member : members) {
            memberInfos.add(this.accountLoader.get(member));
        }
        this.accountLoader.fill();
        memberInfos.sort(AccountInfoComparator.ORDER_NULLS_FIRST);
        return memberInfos;
    }

    private Set<Account.Id> getMembers(AccountGroup.UUID groupUUID, HashSet<AccountGroup.UUID> seenGroups) {
        seenGroups.add(groupUUID);
        Optional<InternalGroup> internalGroup = this.groupCache.get(groupUUID);
        if (!internalGroup.isPresent()) {
            return ImmutableSet.of();
        }
        InternalGroup group = internalGroup.get();
        GroupControl groupControl = this.groupControlFactory.controlFor(new InternalGroupDescription(group));
        Set directMembers = group.getMembers().stream().filter(groupControl::canSeeMember).collect(ImmutableSet.toImmutableSet());
        HashSet<Account.Id> indirectMembers = new HashSet<Account.Id>();
        if (this.recursive && groupControl.canSeeGroup()) {
            for (AccountGroup.UUID subgroupUuid : group.getSubgroups()) {
                if (seenGroups.contains(subgroupUuid)) continue;
                indirectMembers.addAll(this.getMembers(subgroupUuid, seenGroups));
            }
        }
        return Sets.union(directMembers, indirectMembers);
    }
}

