/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.index.IndexDefinition;
import com.google.gerrit.index.SchemaDefinitions;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.index.OnlineUpgradeListener;
import com.google.gerrit.server.index.account.AccountIndexCollection;
import com.google.gerrit.server.index.account.AccountIndexDefinition;
import com.google.gerrit.server.index.account.AccountIndexRewriter;
import com.google.gerrit.server.index.account.AccountIndexer;
import com.google.gerrit.server.index.account.AccountIndexerImpl;
import com.google.gerrit.server.index.account.AccountSchemaDefinitions;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.index.change.ChangeIndexDefinition;
import com.google.gerrit.server.index.change.ChangeIndexRewriter;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.index.change.ChangeSchemaDefinitions;
import com.google.gerrit.server.index.group.GroupIndexCollection;
import com.google.gerrit.server.index.group.GroupIndexDefinition;
import com.google.gerrit.server.index.group.GroupIndexRewriter;
import com.google.gerrit.server.index.group.GroupIndexer;
import com.google.gerrit.server.index.group.GroupIndexerImpl;
import com.google.gerrit.server.index.group.GroupSchemaDefinitions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;

public class IndexModule
extends LifecycleModule {
    public static final ImmutableCollection<SchemaDefinitions<?>> ALL_SCHEMA_DEFS = ImmutableList.of(AccountSchemaDefinitions.INSTANCE, ChangeSchemaDefinitions.INSTANCE, GroupSchemaDefinitions.INSTANCE);
    private final int threads;
    private final ListeningExecutorService interactiveExecutor;
    private final ListeningExecutorService batchExecutor;
    private final boolean closeExecutorsOnShutdown;

    public static IndexType getIndexType(Injector injector) {
        Config cfg = injector.getInstance(Key.get(Config.class, GerritServerConfig.class));
        return cfg.getEnum("index", null, "type", IndexType.LUCENE);
    }

    public IndexModule(int threads) {
        this.threads = threads;
        this.interactiveExecutor = null;
        this.batchExecutor = null;
        this.closeExecutorsOnShutdown = true;
    }

    public IndexModule(ListeningExecutorService interactiveExecutor, ListeningExecutorService batchExecutor) {
        this.threads = -1;
        this.interactiveExecutor = interactiveExecutor;
        this.batchExecutor = batchExecutor;
        this.closeExecutorsOnShutdown = false;
    }

    @Override
    protected void configure() {
        this.bind(AccountIndexRewriter.class);
        this.bind(AccountIndexCollection.class);
        this.listener().to(AccountIndexCollection.class);
        this.factory(AccountIndexerImpl.Factory.class);
        this.bind(ChangeIndexRewriter.class);
        this.bind(ChangeIndexCollection.class);
        this.listener().to(ChangeIndexCollection.class);
        this.factory(ChangeIndexer.Factory.class);
        this.bind(GroupIndexRewriter.class);
        this.bind(GroupIndexCollection.class);
        this.listener().to(GroupIndexCollection.class);
        this.factory(GroupIndexerImpl.Factory.class);
        if (this.closeExecutorsOnShutdown) {
            this.listener().to(ShutdownIndexExecutors.class);
        }
        DynamicSet.setOf(this.binder(), OnlineUpgradeListener.class);
    }

    @Provides
    Collection<IndexDefinition<?, ?, ?>> getIndexDefinitions(AccountIndexDefinition accounts, ChangeIndexDefinition changes, GroupIndexDefinition groups) {
        ImmutableSet actual;
        ImmutableList<IndexDefinition<?, ?, ?>> result = ImmutableList.of(accounts, groups, changes);
        ImmutableSet expected = FluentIterable.from(ALL_SCHEMA_DEFS).transform(SchemaDefinitions::getName).toSet();
        if (!expected.equals(actual = FluentIterable.from(result).transform(IndexDefinition::getName).toSet())) {
            throw new ProvisionException("need index definitions for all schemas: " + expected + " != " + actual);
        }
        return result;
    }

    @Provides
    @Singleton
    AccountIndexer getAccountIndexer(AccountIndexerImpl.Factory factory, AccountIndexCollection indexes) {
        return factory.create(indexes);
    }

    @Provides
    @Singleton
    ChangeIndexer getChangeIndexer(@IndexExecutor(value=QueueProvider.QueueType.INTERACTIVE) ListeningExecutorService executor, ChangeIndexer.Factory factory, ChangeIndexCollection indexes) {
        return factory.create(executor, indexes);
    }

    @Provides
    @Singleton
    GroupIndexer getGroupIndexer(GroupIndexerImpl.Factory factory, GroupIndexCollection indexes) {
        return factory.create(indexes);
    }

    @Provides
    @Singleton
    @IndexExecutor(value=QueueProvider.QueueType.INTERACTIVE)
    ListeningExecutorService getInteractiveIndexExecutor(@GerritServerConfig Config config, WorkQueue workQueue) {
        if (this.interactiveExecutor != null) {
            return this.interactiveExecutor;
        }
        int threads = this.threads;
        if (threads <= 0) {
            threads = config.getInt("index", null, "threads", 0);
        }
        if (threads <= 0) {
            threads = Runtime.getRuntime().availableProcessors() / 2 + 1;
        }
        return MoreExecutors.listeningDecorator(workQueue.createQueue(threads, "Index-Interactive", true));
    }

    @Provides
    @Singleton
    @IndexExecutor(value=QueueProvider.QueueType.BATCH)
    ListeningExecutorService getBatchIndexExecutor(@GerritServerConfig Config config, WorkQueue workQueue) {
        if (this.batchExecutor != null) {
            return this.batchExecutor;
        }
        int batchThreads = this.threads;
        if (batchThreads <= 0) {
            batchThreads = config.getInt("index", null, "batchThreads", 0);
        }
        if (batchThreads <= 0) {
            batchThreads = Runtime.getRuntime().availableProcessors();
        }
        return MoreExecutors.listeningDecorator(workQueue.createQueue(batchThreads, "Index-Batch", true));
    }

    @Singleton
    private static class ShutdownIndexExecutors
    implements LifecycleListener {
        private final ListeningExecutorService interactiveExecutor;
        private final ListeningExecutorService batchExecutor;

        @Inject
        ShutdownIndexExecutors(@IndexExecutor(value=QueueProvider.QueueType.INTERACTIVE) ListeningExecutorService interactiveExecutor, @IndexExecutor(value=QueueProvider.QueueType.BATCH) ListeningExecutorService batchExecutor) {
            this.interactiveExecutor = interactiveExecutor;
            this.batchExecutor = batchExecutor;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
            MoreExecutors.shutdownAndAwaitTermination(this.interactiveExecutor, Long.MAX_VALUE, TimeUnit.SECONDS);
            MoreExecutors.shutdownAndAwaitTermination(this.batchExecutor, Long.MAX_VALUE, TimeUnit.SECONDS);
        }
    }

    public static enum IndexType {
        LUCENE,
        ELASTICSEARCH;

    }
}

