/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.index.Index;
import com.google.gerrit.index.IndexCollection;
import com.google.gerrit.index.IndexDefinition;
import com.google.gerrit.index.SiteIndexer;
import com.google.gerrit.server.index.OnlineUpgradeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnlineReindexer<K, V, I extends Index<K, V>> {
    private static final Logger log = LoggerFactory.getLogger(OnlineReindexer.class);
    private final String name;
    private final IndexCollection<K, V, I> indexes;
    private final SiteIndexer<K, V, I> batchIndexer;
    private final int oldVersion;
    private final int newVersion;
    private final DynamicSet<OnlineUpgradeListener> listeners;
    private I index;
    private final AtomicBoolean running = new AtomicBoolean();

    public OnlineReindexer(IndexDefinition<K, V, I> def, int oldVersion, int newVersion, DynamicSet<OnlineUpgradeListener> listeners) {
        this.name = def.getName();
        this.indexes = def.getIndexCollection();
        this.batchIndexer = def.getSiteIndexer();
        this.oldVersion = oldVersion;
        this.newVersion = newVersion;
        this.listeners = listeners;
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            Thread t = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block6: {
                        boolean ok = false;
                        try {
                            OnlineReindexer.this.reindex();
                            ok = true;
                        }
                        catch (IOException e) {
                            log.error("Online reindex of {} schema version {} failed", OnlineReindexer.this.name, OnlineReindexer.version(OnlineReindexer.this.index), e);
                        }
                        finally {
                            OnlineReindexer.this.running.set(false);
                            if (ok) break block6;
                            for (OnlineUpgradeListener listener : OnlineReindexer.this.listeners) {
                                listener.onFailure(OnlineReindexer.this.name, OnlineReindexer.this.oldVersion, OnlineReindexer.this.newVersion);
                            }
                        }
                    }
                }
            };
            t.setName(String.format("Reindex %s v%d-v%d", this.name, OnlineReindexer.version(this.indexes.getSearchIndex()), this.newVersion));
            t.start();
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getVersion() {
        return this.newVersion;
    }

    private static int version(Index<?, ?> i) {
        return i.getSchema().getVersion();
    }

    private void reindex() throws IOException {
        SiteIndexer.Result result;
        for (OnlineUpgradeListener listener : this.listeners) {
            listener.onStart(this.name, this.oldVersion, this.newVersion);
        }
        this.index = (Index)Preconditions.checkNotNull(this.indexes.getWriteIndex(this.newVersion), "not an active write schema version: %s %s", (Object)this.name, this.newVersion);
        log.info("Starting online reindex of {} from schema version {} to {}", this.name, OnlineReindexer.version(this.indexes.getSearchIndex()), OnlineReindexer.version(this.index));
        if (this.oldVersion != this.newVersion) {
            this.index.deleteAll();
        }
        if (!(result = this.batchIndexer.indexAll(this.index)).success()) {
            log.error("Online reindex of {} schema version {} failed. Successfully indexed {}, failed to index {}", this.name, OnlineReindexer.version(this.index), result.doneCount(), result.failedCount());
            return;
        }
        log.info("Reindex {} to version {} complete", (Object)this.name, (Object)OnlineReindexer.version(this.index));
        this.activateIndex();
        for (OnlineUpgradeListener listener : this.listeners) {
            listener.onSuccess(this.name, this.oldVersion, this.newVersion);
        }
    }

    public void activateIndex() {
        this.indexes.setSearchIndex(this.index);
        log.info("Using {} schema version {}", (Object)this.name, (Object)OnlineReindexer.version(this.index));
        try {
            this.index.markReady(true);
        }
        catch (IOException e) {
            log.warn("Error activating new {} schema version {}", (Object)this.name, (Object)OnlineReindexer.version(this.index));
        }
        ArrayList<Index> toRemove = Lists.newArrayListWithExpectedSize(1);
        for (Index i : this.indexes.getWriteIndexes()) {
            if (OnlineReindexer.version(i) == OnlineReindexer.version(this.index)) continue;
            toRemove.add(i);
        }
        for (Index i : toRemove) {
            try {
                i.markReady(false);
                this.indexes.removeWriteIndex(OnlineReindexer.version(i));
            }
            catch (IOException e) {
                log.warn("Error deactivating old {} schema version {}", (Object)this.name, (Object)OnlineReindexer.version(i));
            }
        }
    }
}

