/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.common.base.Joiner;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.OutgoingEmail;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.List;

public class AddKeySender
extends OutgoingEmail {
    private final PermissionBackend permissionBackend;
    private final IdentifiedUser callingUser;
    private final IdentifiedUser user;
    private final AccountSshKey sshKey;
    private final List<String> gpgKeys;

    @AssistedInject
    public AddKeySender(EmailArguments ea, PermissionBackend permissionBackend, IdentifiedUser callingUser, @Assisted IdentifiedUser user, @Assisted AccountSshKey sshKey) {
        super(ea, "addkey");
        this.permissionBackend = permissionBackend;
        this.callingUser = callingUser;
        this.user = user;
        this.sshKey = sshKey;
        this.gpgKeys = null;
    }

    @AssistedInject
    public AddKeySender(EmailArguments ea, PermissionBackend permissionBackend, IdentifiedUser callingUser, @Assisted IdentifiedUser user, @Assisted List<String> gpgKeys) {
        super(ea, "addkey");
        this.permissionBackend = permissionBackend;
        this.callingUser = callingUser;
        this.user = user;
        this.sshKey = null;
        this.gpgKeys = gpgKeys;
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.setHeader("Subject", String.format("[Gerrit Code Review] New %s Keys Added", this.getKeyType()));
        this.add(RecipientType.TO, new Address(this.getEmail()));
    }

    @Override
    protected boolean shouldSendMessage() {
        if (this.sshKey == null && (this.gpgKeys == null || this.gpgKeys.isEmpty())) {
            return false;
        }
        if (this.user.equals(this.callingUser)) {
            return true;
        }
        try {
            this.permissionBackend.user(this.callingUser).check(GlobalPermission.ADMINISTRATE_SERVER);
            return false;
        }
        catch (AuthException | PermissionBackendException e) {
            return true;
        }
    }

    @Override
    protected void format() throws EmailException {
        this.appendText(this.textTemplate("AddKey"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("AddKeyHtml"));
        }
    }

    public String getEmail() {
        return this.user.getAccount().getPreferredEmail();
    }

    public String getUserNameEmail() {
        return this.getUserNameEmailFor(this.user.getAccountId());
    }

    public String getKeyType() {
        if (this.sshKey != null) {
            return "SSH";
        }
        if (this.gpgKeys != null) {
            return "GPG";
        }
        return "Unknown";
    }

    public String getSshKey() {
        return this.sshKey != null ? this.sshKey.getSshPublicKey() + "\n" : null;
    }

    public String getGpgKeys() {
        if (this.gpgKeys != null) {
            return Joiner.on("\n").join(this.gpgKeys);
        }
        return null;
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        this.soyContextEmailData.put("email", this.getEmail());
        this.soyContextEmailData.put("gpgKeys", this.getGpgKeys());
        this.soyContextEmailData.put("keyType", this.getKeyType());
        this.soyContextEmailData.put("sshKey", this.getSshKey());
        this.soyContextEmailData.put("userNameEmail", this.getUserNameEmail());
    }

    @Override
    protected boolean supportsHtml() {
        return true;
    }

    public static interface Factory {
        public AddKeySender create(IdentifiedUser var1, AccountSshKey var2);

        public AddKeySender create(IdentifiedUser var1, List<String> var2);
    }
}

