/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.ReplyToChangeSender;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ReplacePatchSetSender
extends ReplyToChangeSender {
    private final Set<Account.Id> reviewers = new HashSet<Account.Id>();
    private final Set<Account.Id> extraCC = new HashSet<Account.Id>();

    @Inject
    public ReplacePatchSetSender(EmailArguments ea, @Assisted Project.NameKey project, @Assisted Change.Id id) throws OrmException {
        super(ea, "newpatchset", ReplacePatchSetSender.newChangeData(ea, project, id));
    }

    public void addReviewers(Collection<Account.Id> cc) {
        this.reviewers.addAll(cc);
    }

    public void addExtraCC(Collection<Account.Id> cc) {
        this.extraCC.addAll(cc);
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        if (this.fromId != null) {
            this.reviewers.remove(this.fromId);
        }
        if (this.notify == NotifyHandling.ALL || this.notify == NotifyHandling.OWNER_REVIEWERS) {
            this.add(RecipientType.TO, this.reviewers);
            this.add(RecipientType.CC, this.extraCC);
        }
        this.rcptToAuthors(RecipientType.CC);
        this.bccStarredBy();
        this.includeWatchers(WatchConfig.NotifyType.NEW_PATCHSETS, !this.change.isWorkInProgress() && !this.change.isPrivate());
        this.removeUsersThatIgnoredTheChange();
    }

    @Override
    protected void formatChange() throws EmailException {
        this.appendText(this.textTemplate("ReplacePatchSet"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("ReplacePatchSetHtml"));
        }
    }

    public List<String> getReviewerNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Account.Id id : this.reviewers) {
            if (id.equals(this.fromId)) continue;
            names.add(this.getNameFor(id));
        }
        if (names.isEmpty()) {
            return null;
        }
        return names;
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        this.soyContextEmailData.put("reviewerNames", this.getReviewerNames());
    }

    @Override
    protected boolean supportsHtml() {
        return true;
    }

    public static interface Factory {
        public ReplacePatchSetSender create(Project.NameKey var1, Change.Id var2);
    }
}

