/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.auto.value.AutoValue;
import com.google.common.base.Enums;
import com.google.common.base.Splitter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.primitives.Ints;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.metrics.Timer1;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.LabelId;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.ReviewerByEmailSet;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.ReviewerStatusUpdate;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.notedb.AutoValue_ChangeNotesParser_ApprovalKey;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeNotesCommit;
import com.google.gerrit.server.notedb.ChangeNotesState;
import com.google.gerrit.server.notedb.ChangeRevisionNote;
import com.google.gerrit.server.notedb.NoteDbMetrics;
import com.google.gerrit.server.notedb.NoteDbTable;
import com.google.gerrit.server.notedb.PatchSetState;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.notedb.RevisionNoteMap;
import com.google.gerrit.server.util.LabelVote;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.InvalidObjectIdException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.util.GitDateParser;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangeNotesParser {
    private static final Logger log = LoggerFactory.getLogger(ChangeNotesParser.class);
    private static final RevId PARTIAL_PATCH_SET = new RevId("INVALID PARTIAL PATCH SET");
    private final ChangeNoteUtil noteUtil;
    private final NoteDbMetrics metrics;
    private final Change.Id id;
    private final ObjectId tip;
    private final ChangeNotesCommit.ChangeNotesRevWalk walk;
    private final Table<Account.Id, ReviewerStateInternal, Timestamp> reviewers;
    private final Table<Address, ReviewerStateInternal, Timestamp> reviewersByEmail;
    private final List<Account.Id> allPastReviewers;
    private final List<ReviewerStatusUpdate> reviewerUpdates;
    private final List<SubmitRecord> submitRecords;
    private final ListMultimap<RevId, Comment> comments;
    private final Map<PatchSet.Id, PatchSet> patchSets;
    private final Set<PatchSet.Id> deletedPatchSets;
    private final Map<PatchSet.Id, PatchSetState> patchSetStates;
    private final List<PatchSet.Id> currentPatchSets;
    private final Map<ApprovalKey, PatchSetApproval> approvals;
    private final List<PatchSetApproval> bufferedApprovals;
    private final List<ChangeMessage> allChangeMessages;
    private final ListMultimap<PatchSet.Id, ChangeMessage> changeMessagesByPatchSet;
    private String branch;
    private Change.Status status;
    private String topic;
    private Optional<Account.Id> assignee;
    private List<Account.Id> pastAssignees;
    private Set<String> hashtags;
    private Timestamp createdOn;
    private Timestamp lastUpdatedOn;
    private Account.Id ownerId;
    private String changeId;
    private String subject;
    private String originalSubject;
    private String submissionId;
    private String tag;
    private RevisionNoteMap<ChangeRevisionNote> revisionNoteMap;
    private Timestamp readOnlyUntil;
    private Boolean isPrivate;
    private Boolean workInProgress;
    private Boolean previousWorkInProgressFooter;
    private Boolean hasReviewStarted;
    private ReviewerSet pendingReviewers;
    private ReviewerByEmailSet pendingReviewersByEmail;
    private Change.Id revertOf;

    ChangeNotesParser(Change.Id changeId, ObjectId tip, ChangeNotesCommit.ChangeNotesRevWalk walk, ChangeNoteUtil noteUtil, NoteDbMetrics metrics) {
        this.id = changeId;
        this.tip = tip;
        this.walk = walk;
        this.noteUtil = noteUtil;
        this.metrics = metrics;
        this.approvals = new LinkedHashMap<ApprovalKey, PatchSetApproval>();
        this.bufferedApprovals = new ArrayList<PatchSetApproval>();
        this.reviewers = HashBasedTable.create();
        this.reviewersByEmail = HashBasedTable.create();
        this.pendingReviewers = ReviewerSet.empty();
        this.pendingReviewersByEmail = ReviewerByEmailSet.empty();
        this.allPastReviewers = new ArrayList<Account.Id>();
        this.reviewerUpdates = new ArrayList<ReviewerStatusUpdate>();
        this.submitRecords = Lists.newArrayListWithExpectedSize(1);
        this.allChangeMessages = new ArrayList<ChangeMessage>();
        this.changeMessagesByPatchSet = LinkedListMultimap.create();
        this.comments = MultimapBuilder.hashKeys().arrayListValues().build();
        this.patchSets = new HashMap<PatchSet.Id, PatchSet>();
        this.deletedPatchSets = new HashSet<PatchSet.Id>();
        this.patchSetStates = new HashMap<PatchSet.Id, PatchSetState>();
        this.currentPatchSets = new ArrayList<PatchSet.Id>();
    }

    ChangeNotesState parseAll() throws ConfigInvalidException, IOException {
        this.walk.reset();
        this.walk.markStart(this.walk.parseCommit(this.tip));
        try (Timer1.Context timer = this.metrics.parseLatency.start(NoteDbTable.CHANGES);){
            ChangeNotesCommit commit;
            while ((commit = this.walk.next()) != null) {
                this.parse(commit);
            }
            if (this.hasReviewStarted == null) {
                this.hasReviewStarted = this.previousWorkInProgressFooter == null ? Boolean.valueOf(true) : Boolean.valueOf(this.previousWorkInProgressFooter == false);
            }
            this.parseNotes();
            this.allPastReviewers.addAll(this.reviewers.rowKeySet());
            this.pruneReviewers();
            this.pruneReviewersByEmail();
            this.updatePatchSetStates();
            this.checkMandatoryFooters();
        }
        return this.buildState();
    }

    RevisionNoteMap<ChangeRevisionNote> getRevisionNoteMap() {
        return this.revisionNoteMap;
    }

    private ChangeNotesState buildState() {
        return ChangeNotesState.create(this.tip.copy(), this.id, new Change.Key(this.changeId), this.createdOn, this.lastUpdatedOn, this.ownerId, this.branch, this.buildCurrentPatchSetId(), this.subject, this.topic, this.originalSubject, this.submissionId, this.assignee != null ? (Account.Id)this.assignee.orElse(null) : null, this.status, Sets.newLinkedHashSet(Lists.reverse(this.pastAssignees)), this.hashtags, this.patchSets, this.buildApprovals(), ReviewerSet.fromTable(Tables.transpose(this.reviewers)), ReviewerByEmailSet.fromTable(Tables.transpose(this.reviewersByEmail)), this.pendingReviewers, this.pendingReviewersByEmail, this.allPastReviewers, this.buildReviewerUpdates(), this.submitRecords, this.buildAllMessages(), this.buildMessagesByPatchSet(), this.comments, this.readOnlyUntil, this.isPrivate, this.workInProgress, this.hasReviewStarted, this.revertOf);
    }

    private PatchSet.Id buildCurrentPatchSetId() {
        for (PatchSet.Id psId : this.currentPatchSets) {
            if (!this.patchSets.containsKey(psId)) continue;
            return psId;
        }
        return null;
    }

    private ListMultimap<PatchSet.Id, PatchSetApproval> buildApprovals() {
        Multimap result = MultimapBuilder.hashKeys().arrayListValues().build();
        for (PatchSetApproval patchSetApproval : this.approvals.values()) {
            if (!this.patchSets.containsKey(patchSetApproval.getPatchSetId()) || this.allPastReviewers.contains(patchSetApproval.getAccountId()) && !this.reviewers.containsRow(patchSetApproval.getAccountId())) continue;
            result.put(patchSetApproval.getPatchSetId(), patchSetApproval);
        }
        for (Collection collection : result.asMap().values()) {
            Collections.sort((List)collection, ChangeNotes.PSA_BY_TIME);
        }
        return result;
    }

    private List<ReviewerStatusUpdate> buildReviewerUpdates() {
        ArrayList<ReviewerStatusUpdate> result = new ArrayList<ReviewerStatusUpdate>();
        HashMap<Account.Id, ReviewerStateInternal> lastState = new HashMap<Account.Id, ReviewerStateInternal>();
        for (ReviewerStatusUpdate u : Lists.reverse(this.reviewerUpdates)) {
            if (Objects.equals(this.ownerId, u.reviewer()) || lastState.get(u.reviewer()) == u.state()) continue;
            result.add(u);
            lastState.put(u.reviewer(), u.state());
        }
        return result;
    }

    private List<ChangeMessage> buildAllMessages() {
        return Lists.reverse(this.allChangeMessages);
    }

    private ListMultimap<PatchSet.Id, ChangeMessage> buildMessagesByPatchSet() {
        for (Collection<ChangeMessage> v : this.changeMessagesByPatchSet.asMap().values()) {
            Collections.reverse((List)v);
        }
        return this.changeMessagesByPatchSet;
    }

    private void parse(ChangeNotesCommit commit) throws ConfigInvalidException {
        ObjectId currRev;
        String currSubject;
        Account.Id accountId;
        Timestamp ts;
        this.createdOn = ts = new Timestamp(commit.getCommitterIdent().getWhen().getTime());
        this.parseTag(commit);
        if (this.branch == null) {
            this.branch = this.parseBranch(commit);
        }
        PatchSet.Id psId = this.parsePatchSetId(commit);
        PatchSetState psState = this.parsePatchSetState(commit);
        if (psState != null) {
            if (!this.patchSetStates.containsKey(psId)) {
                this.patchSetStates.put(psId, psState);
            }
            if (psState == PatchSetState.DELETED) {
                this.deletedPatchSets.add(psId);
            }
        }
        if ((accountId = this.parseIdent(commit)) != null) {
            this.ownerId = accountId;
        }
        Account.Id realAccountId = this.parseRealAccountId(commit, accountId);
        if (this.changeId == null) {
            this.changeId = this.parseChangeId(commit);
        }
        if ((currSubject = this.parseSubject(commit)) != null) {
            if (this.subject == null) {
                this.subject = currSubject;
            }
            this.originalSubject = currSubject;
        }
        this.parseChangeMessage(psId, accountId, realAccountId, commit, ts);
        if (this.topic == null) {
            this.topic = this.parseTopic(commit);
        }
        this.parseHashtags(commit);
        this.parseAssignee(commit);
        if (this.submissionId == null) {
            this.submissionId = this.parseSubmissionId(commit);
        }
        if ((currRev = this.parseRevision(commit)) != null) {
            this.parsePatchSet(psId, currRev, accountId, ts);
        }
        this.parseGroups(psId, commit);
        this.parseCurrentPatchSet(psId, commit);
        if (this.submitRecords.isEmpty()) {
            this.parseSubmitRecords(commit.getFooterLineValues(ChangeNoteUtil.FOOTER_SUBMITTED_WITH));
        }
        if (this.status == null) {
            this.status = this.parseStatus(commit);
        }
        for (String line : commit.getFooterLineValues(ChangeNoteUtil.FOOTER_LABEL)) {
            this.parseApproval(psId, accountId, realAccountId, ts, line);
        }
        for (ReviewerStateInternal state : ReviewerStateInternal.values()) {
            for (String line : commit.getFooterLineValues(state.getFooterKey())) {
                this.parseReviewer(ts, state, line);
            }
            for (String line : commit.getFooterLineValues(state.getByEmailFooterKey())) {
                this.parseReviewerByEmail(ts, state, line);
            }
        }
        if (this.readOnlyUntil == null) {
            this.parseReadOnlyUntil(commit);
        }
        if (this.isPrivate == null) {
            this.parseIsPrivate(commit);
        }
        if (this.revertOf == null) {
            this.revertOf = this.parseRevertOf(commit);
        }
        this.previousWorkInProgressFooter = null;
        this.parseWorkInProgress(commit);
        if (this.lastUpdatedOn == null || ts.after(this.lastUpdatedOn)) {
            this.lastUpdatedOn = ts;
        }
        this.parseDescription(psId, commit);
    }

    private String parseSubmissionId(ChangeNotesCommit commit) throws ConfigInvalidException {
        return this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_SUBMISSION_ID);
    }

    private String parseBranch(ChangeNotesCommit commit) throws ConfigInvalidException {
        String branch = this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_BRANCH);
        return branch != null ? RefNames.fullName(branch) : null;
    }

    private String parseChangeId(ChangeNotesCommit commit) throws ConfigInvalidException {
        return this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_CHANGE_ID);
    }

    private String parseSubject(ChangeNotesCommit commit) throws ConfigInvalidException {
        return this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_SUBJECT);
    }

    private Account.Id parseRealAccountId(ChangeNotesCommit commit, Account.Id effectiveAccountId) throws ConfigInvalidException {
        String realUser = this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_REAL_USER);
        if (realUser == null) {
            return effectiveAccountId;
        }
        PersonIdent ident = RawParseUtils.parsePersonIdent(realUser);
        return this.noteUtil.parseIdent(ident, this.id);
    }

    private String parseTopic(ChangeNotesCommit commit) throws ConfigInvalidException {
        return this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_TOPIC);
    }

    private String parseOneFooter(ChangeNotesCommit commit, FooterKey footerKey) throws ConfigInvalidException {
        List<String> footerLines = commit.getFooterLineValues(footerKey);
        if (footerLines.isEmpty()) {
            return null;
        }
        if (footerLines.size() > 1) {
            throw this.expectedOneFooter(footerKey, footerLines);
        }
        return footerLines.get(0);
    }

    private String parseExactlyOneFooter(ChangeNotesCommit commit, FooterKey footerKey) throws ConfigInvalidException {
        String line = this.parseOneFooter(commit, footerKey);
        if (line == null) {
            throw this.expectedOneFooter(footerKey, Collections.emptyList());
        }
        return line;
    }

    private ObjectId parseRevision(ChangeNotesCommit commit) throws ConfigInvalidException {
        String sha = this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_COMMIT);
        if (sha == null) {
            return null;
        }
        try {
            return ObjectId.fromString(sha);
        }
        catch (InvalidObjectIdException e) {
            ConfigInvalidException cie = this.invalidFooter(ChangeNoteUtil.FOOTER_COMMIT, sha);
            cie.initCause(e);
            throw cie;
        }
    }

    private void parsePatchSet(PatchSet.Id psId, ObjectId rev, Account.Id accountId, Timestamp ts) throws ConfigInvalidException {
        if (accountId == null) {
            throw this.parseException("patch set %s requires an identified user as uploader", psId.get());
        }
        PatchSet ps = this.patchSets.get(psId);
        if (ps == null) {
            ps = new PatchSet(psId);
            this.patchSets.put(psId, ps);
        } else if (!ps.getRevision().equals(PARTIAL_PATCH_SET)) {
            if (this.deletedPatchSets.contains(psId)) {
                return;
            }
            throw new ConfigInvalidException(String.format("Multiple revisions parsed for patch set %s: %s and %s", psId.get(), this.patchSets.get(psId).getRevision(), rev.name()));
        }
        ps.setRevision(new RevId(rev.name()));
        ps.setUploader(accountId);
        ps.setCreatedOn(ts);
    }

    private void parseGroups(PatchSet.Id psId, ChangeNotesCommit commit) throws ConfigInvalidException {
        String groupsStr = this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_GROUPS);
        if (groupsStr == null) {
            return;
        }
        PatchSet ps = this.patchSets.get(psId);
        if (ps == null) {
            ps = new PatchSet(psId);
            ps.setRevision(PARTIAL_PATCH_SET);
            this.patchSets.put(psId, ps);
        } else if (!ps.getGroups().isEmpty()) {
            return;
        }
        ps.setGroups(PatchSet.splitGroups(groupsStr));
    }

    private void parseCurrentPatchSet(PatchSet.Id psId, ChangeNotesCommit commit) throws ConfigInvalidException {
        boolean current = false;
        if (this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_COMMIT) != null) {
            current = true;
        } else {
            String currentStr = this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_CURRENT);
            if (Boolean.TRUE.toString().equalsIgnoreCase(currentStr)) {
                current = true;
            } else if (currentStr != null) {
                throw this.invalidFooter(ChangeNoteUtil.FOOTER_CURRENT, currentStr);
            }
        }
        if (current) {
            this.currentPatchSets.add(psId);
        }
    }

    private void parseHashtags(ChangeNotesCommit commit) throws ConfigInvalidException {
        if (this.hashtags != null) {
            return;
        }
        List<String> hashtagsLines = commit.getFooterLineValues(ChangeNoteUtil.FOOTER_HASHTAGS);
        if (hashtagsLines.isEmpty()) {
            return;
        }
        if (hashtagsLines.size() > 1) {
            throw this.expectedOneFooter(ChangeNoteUtil.FOOTER_HASHTAGS, hashtagsLines);
        }
        this.hashtags = hashtagsLines.get(0).isEmpty() ? ImmutableSet.of() : Sets.newHashSet(Splitter.on(',').split(hashtagsLines.get(0)));
    }

    private void parseAssignee(ChangeNotesCommit commit) throws ConfigInvalidException {
        String assigneeValue;
        if (this.pastAssignees == null) {
            this.pastAssignees = Lists.newArrayList();
        }
        if ((assigneeValue = this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_ASSIGNEE)) != null) {
            Optional<Object> parsedAssignee;
            if (assigneeValue.equals("")) {
                parsedAssignee = Optional.empty();
            } else {
                PersonIdent ident = RawParseUtils.parsePersonIdent(assigneeValue);
                parsedAssignee = Optional.ofNullable(this.noteUtil.parseIdent(ident, this.id));
            }
            if (this.assignee == null) {
                this.assignee = parsedAssignee;
            }
            if (parsedAssignee.isPresent()) {
                this.pastAssignees.add((Account.Id)parsedAssignee.get());
            }
        }
    }

    private void parseTag(ChangeNotesCommit commit) throws ConfigInvalidException {
        this.tag = null;
        List<String> tagLines = commit.getFooterLineValues(ChangeNoteUtil.FOOTER_TAG);
        if (tagLines.isEmpty()) {
            return;
        }
        if (tagLines.size() != 1) {
            throw this.expectedOneFooter(ChangeNoteUtil.FOOTER_TAG, tagLines);
        }
        this.tag = tagLines.get(0);
    }

    private Change.Status parseStatus(ChangeNotesCommit commit) throws ConfigInvalidException {
        List<String> statusLines = commit.getFooterLineValues(ChangeNoteUtil.FOOTER_STATUS);
        if (statusLines.isEmpty()) {
            return null;
        }
        if (statusLines.size() > 1) {
            throw this.expectedOneFooter(ChangeNoteUtil.FOOTER_STATUS, statusLines);
        }
        Change.Status status = Enums.getIfPresent(Change.Status.class, statusLines.get(0).toUpperCase()).orNull();
        if (status == null) {
            throw this.invalidFooter(ChangeNoteUtil.FOOTER_STATUS, statusLines.get(0));
        }
        if (status == Change.Status.MERGED) {
            for (PatchSetApproval psa : this.bufferedApprovals) {
                if (psa.isLegacySubmit()) continue;
                psa.setPostSubmit(true);
            }
        }
        this.bufferedApprovals.clear();
        return status;
    }

    private PatchSet.Id parsePatchSetId(ChangeNotesCommit commit) throws ConfigInvalidException {
        String psIdLine = this.parseExactlyOneFooter(commit, ChangeNoteUtil.FOOTER_PATCH_SET);
        int s = psIdLine.indexOf(32);
        String psIdStr = s < 0 ? psIdLine : psIdLine.substring(0, s);
        Integer psId = Ints.tryParse(psIdStr);
        if (psId == null) {
            throw this.invalidFooter(ChangeNoteUtil.FOOTER_PATCH_SET, psIdStr);
        }
        return new PatchSet.Id(this.id, psId);
    }

    private PatchSetState parsePatchSetState(ChangeNotesCommit commit) throws ConfigInvalidException {
        PatchSetState state;
        String psIdLine = this.parseExactlyOneFooter(commit, ChangeNoteUtil.FOOTER_PATCH_SET);
        int s = psIdLine.indexOf(32);
        if (s < 0) {
            return null;
        }
        String withParens = psIdLine.substring(s + 1);
        if (withParens.startsWith("(") && withParens.endsWith(")") && (state = Enums.getIfPresent(PatchSetState.class, withParens.substring(1, withParens.length() - 1).toUpperCase()).orNull()) != null) {
            return state;
        }
        throw this.invalidFooter(ChangeNoteUtil.FOOTER_PATCH_SET, psIdLine);
    }

    private void parseDescription(PatchSet.Id psId, ChangeNotesCommit commit) throws ConfigInvalidException {
        List<String> descLines = commit.getFooterLineValues(ChangeNoteUtil.FOOTER_PATCH_SET_DESCRIPTION);
        if (descLines.isEmpty()) {
            return;
        }
        if (descLines.size() == 1) {
            String desc = descLines.get(0).trim();
            PatchSet ps = this.patchSets.get(psId);
            if (ps == null) {
                ps = new PatchSet(psId);
                ps.setRevision(PARTIAL_PATCH_SET);
                this.patchSets.put(psId, ps);
            }
            if (ps.getDescription() == null) {
                ps.setDescription(desc);
            }
        } else {
            throw this.expectedOneFooter(ChangeNoteUtil.FOOTER_PATCH_SET_DESCRIPTION, descLines);
        }
    }

    private void parseChangeMessage(PatchSet.Id psId, Account.Id accountId, Account.Id realAccountId, ChangeNotesCommit commit, Timestamp ts) {
        int changeMessageStart;
        byte[] raw = commit.getRawBuffer();
        int size = raw.length;
        Charset enc = RawParseUtils.parseEncoding(raw);
        int subjectStart = RawParseUtils.commitMessage(raw, 0);
        if (subjectStart < 0 || subjectStart >= size) {
            return;
        }
        int subjectEnd = RawParseUtils.endOfParagraph(raw, subjectStart);
        if (subjectEnd == size) {
            return;
        }
        if (raw[subjectEnd] == 10) {
            changeMessageStart = subjectEnd + 2;
        } else if (raw[subjectEnd] == 13) {
            changeMessageStart = subjectEnd + 4;
        } else {
            return;
        }
        int ptr = size - 1;
        int changeMessageEnd = -1;
        while (ptr > changeMessageStart && (ptr = RawParseUtils.prevLF(raw, ptr, '\r')) != -1) {
            if (raw[ptr] == 10) {
                changeMessageEnd = ptr - 1;
                break;
            }
            if (raw[ptr] != 13) continue;
            changeMessageEnd = ptr - 3;
            break;
        }
        if (ptr <= changeMessageStart) {
            return;
        }
        String changeMsgString = RawParseUtils.decode(enc, raw, changeMessageStart, changeMessageEnd + 1);
        ChangeMessage changeMessage = new ChangeMessage(new ChangeMessage.Key(psId.getParentKey(), commit.name()), accountId, ts, psId);
        changeMessage.setMessage(changeMsgString);
        changeMessage.setTag(this.tag);
        changeMessage.setRealAuthor(realAccountId);
        this.changeMessagesByPatchSet.put(psId, changeMessage);
        this.allChangeMessages.add(changeMessage);
    }

    private void parseNotes() throws IOException, ConfigInvalidException {
        ObjectReader reader = this.walk.getObjectReader();
        ChangeNotesCommit tipCommit = this.walk.parseCommit(this.tip);
        this.revisionNoteMap = RevisionNoteMap.parse(this.noteUtil, this.id, reader, NoteMap.read(reader, tipCommit), PatchLineComment.Status.PUBLISHED);
        ImmutableMap rns = this.revisionNoteMap.revisionNotes;
        for (Map.Entry e : rns.entrySet()) {
            for (Comment c : ((ChangeRevisionNote)e.getValue()).getComments()) {
                this.comments.put((RevId)e.getKey(), c);
            }
        }
        for (PatchSet ps : this.patchSets.values()) {
            ChangeRevisionNote rn = (ChangeRevisionNote)rns.get(ps.getRevision());
            if (rn == null || rn.getPushCert() == null) continue;
            ps.setPushCertificate(rn.getPushCert());
        }
    }

    private void parseApproval(PatchSet.Id psId, Account.Id accountId, Account.Id realAccountId, Timestamp ts, String line) throws ConfigInvalidException {
        if (accountId == null) {
            throw this.parseException("patch set %s requires an identified user as uploader", psId.get());
        }
        PatchSetApproval psa = line.startsWith("-") ? this.parseRemoveApproval(psId, accountId, realAccountId, ts, line) : this.parseAddApproval(psId, accountId, realAccountId, ts, line);
        this.bufferedApprovals.add(psa);
    }

    private PatchSetApproval parseAddApproval(PatchSet.Id psId, Account.Id committerId, Account.Id realAccountId, Timestamp ts, String line) throws ConfigInvalidException {
        ApprovalKey k;
        LabelVote l;
        Account.Id effectiveAccountId;
        String labelVoteStr;
        int s = line.indexOf(32);
        if (s > 0) {
            labelVoteStr = line.substring(0, s);
            PersonIdent ident = RawParseUtils.parsePersonIdent(line.substring(s + 1));
            this.checkFooter(ident != null, ChangeNoteUtil.FOOTER_LABEL, line);
            effectiveAccountId = this.noteUtil.parseIdent(ident, this.id);
        } else {
            labelVoteStr = line;
            effectiveAccountId = committerId;
        }
        try {
            l = LabelVote.parseWithEquals(labelVoteStr);
        }
        catch (IllegalArgumentException e) {
            ConfigInvalidException pe = this.parseException("invalid %s: %s", ChangeNoteUtil.FOOTER_LABEL, line);
            pe.initCause(e);
            throw pe;
        }
        PatchSetApproval psa = new PatchSetApproval(new PatchSetApproval.Key(psId, effectiveAccountId, new LabelId(l.label())), l.value(), ts);
        psa.setTag(this.tag);
        if (!Objects.equals(realAccountId, committerId)) {
            psa.setRealAccountId(realAccountId);
        }
        if (!this.approvals.containsKey(k = ApprovalKey.create(psId, effectiveAccountId, l.label()))) {
            this.approvals.put(k, psa);
        }
        return psa;
    }

    private PatchSetApproval parseRemoveApproval(PatchSet.Id psId, Account.Id committerId, Account.Id realAccountId, Timestamp ts, String line) throws ConfigInvalidException {
        ApprovalKey k;
        Account.Id effectiveAccountId;
        String label;
        int s = line.indexOf(32);
        if (s > 0) {
            label = line.substring(1, s);
            PersonIdent ident = RawParseUtils.parsePersonIdent(line.substring(s + 1));
            this.checkFooter(ident != null, ChangeNoteUtil.FOOTER_LABEL, line);
            effectiveAccountId = this.noteUtil.parseIdent(ident, this.id);
        } else {
            label = line.substring(1);
            effectiveAccountId = committerId;
        }
        try {
            LabelType.checkNameInternal(label);
        }
        catch (IllegalArgumentException e) {
            ConfigInvalidException pe = this.parseException("invalid %s: %s", ChangeNoteUtil.FOOTER_LABEL, line);
            pe.initCause(e);
            throw pe;
        }
        PatchSetApproval remove = new PatchSetApproval(new PatchSetApproval.Key(psId, effectiveAccountId, new LabelId(label)), 0, ts);
        if (!Objects.equals(realAccountId, committerId)) {
            remove.setRealAccountId(realAccountId);
        }
        if (!this.approvals.containsKey(k = ApprovalKey.create(psId, effectiveAccountId, label))) {
            this.approvals.put(k, remove);
        }
        return remove;
    }

    private void parseSubmitRecords(List<String> lines) throws ConfigInvalidException {
        SubmitRecord rec = null;
        for (String line : lines) {
            int c = line.indexOf(": ");
            if (c < 0) {
                rec = new SubmitRecord();
                this.submitRecords.add(rec);
                int s = line.indexOf(32);
                String statusStr = s >= 0 ? line.substring(0, s) : line;
                rec.status = Enums.getIfPresent(SubmitRecord.Status.class, statusStr).orNull();
                this.checkFooter(rec.status != null, ChangeNoteUtil.FOOTER_SUBMITTED_WITH, line);
                if (s < 0) continue;
                rec.errorMessage = line.substring(s);
                continue;
            }
            this.checkFooter(rec != null, ChangeNoteUtil.FOOTER_SUBMITTED_WITH, line);
            SubmitRecord.Label label = new SubmitRecord.Label();
            if (rec.labels == null) {
                rec.labels = new ArrayList<SubmitRecord.Label>();
            }
            rec.labels.add(label);
            label.status = Enums.getIfPresent(SubmitRecord.Label.Status.class, line.substring(0, c)).orNull();
            this.checkFooter(label.status != null, ChangeNoteUtil.FOOTER_SUBMITTED_WITH, line);
            int c2 = line.indexOf(": ", c + 2);
            if (c2 >= 0) {
                label.label = line.substring(c + 2, c2);
                PersonIdent ident = RawParseUtils.parsePersonIdent(line.substring(c2 + 2));
                this.checkFooter(ident != null, ChangeNoteUtil.FOOTER_SUBMITTED_WITH, line);
                label.appliedBy = this.noteUtil.parseIdent(ident, this.id);
                continue;
            }
            label.label = line.substring(c + 2);
        }
    }

    private Account.Id parseIdent(ChangeNotesCommit commit) throws ConfigInvalidException {
        PersonIdent a = commit.getAuthorIdent();
        PersonIdent c = commit.getCommitterIdent();
        if (a.getName().equals(c.getName()) && a.getEmailAddress().equals(c.getEmailAddress())) {
            return null;
        }
        return this.noteUtil.parseIdent(commit.getAuthorIdent(), this.id);
    }

    private void parseReviewer(Timestamp ts, ReviewerStateInternal state, String line) throws ConfigInvalidException {
        PersonIdent ident = RawParseUtils.parsePersonIdent(line);
        if (ident == null) {
            throw this.invalidFooter(state.getFooterKey(), line);
        }
        Account.Id accountId = this.noteUtil.parseIdent(ident, this.id);
        this.reviewerUpdates.add(ReviewerStatusUpdate.create(ts, this.ownerId, accountId, state));
        if (!this.reviewers.containsRow(accountId)) {
            this.reviewers.put(accountId, state, ts);
        }
    }

    private void parseReviewerByEmail(Timestamp ts, ReviewerStateInternal state, String line) throws ConfigInvalidException {
        Address adr;
        try {
            adr = Address.parse(line);
        }
        catch (IllegalArgumentException e) {
            throw this.invalidFooter(state.getByEmailFooterKey(), line);
        }
        if (!this.reviewersByEmail.containsRow(adr)) {
            this.reviewersByEmail.put(adr, state, ts);
        }
    }

    private void parseReadOnlyUntil(ChangeNotesCommit commit) throws ConfigInvalidException {
        String raw = this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_READ_ONLY_UNTIL);
        if (raw == null) {
            return;
        }
        try {
            this.readOnlyUntil = new Timestamp(GitDateParser.parse(raw, null, Locale.US).getTime());
        }
        catch (ParseException e) {
            ConfigInvalidException cie = this.invalidFooter(ChangeNoteUtil.FOOTER_READ_ONLY_UNTIL, raw);
            cie.initCause(e);
            throw cie;
        }
    }

    private void parseIsPrivate(ChangeNotesCommit commit) throws ConfigInvalidException {
        String raw = this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_PRIVATE);
        if (raw == null) {
            return;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(raw)) {
            this.isPrivate = true;
            return;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(raw)) {
            this.isPrivate = false;
            return;
        }
        throw this.invalidFooter(ChangeNoteUtil.FOOTER_PRIVATE, raw);
    }

    private void parseWorkInProgress(ChangeNotesCommit commit) throws ConfigInvalidException {
        String raw = this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_WORK_IN_PROGRESS);
        if (raw == null) {
            this.previousWorkInProgressFooter = null;
            return;
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(raw)) {
            this.previousWorkInProgressFooter = true;
            if (this.workInProgress == null) {
                this.pendingReviewers = ReviewerSet.fromTable(Tables.transpose(ImmutableTable.copyOf(this.reviewers)));
                this.pendingReviewersByEmail = ReviewerByEmailSet.fromTable(Tables.transpose(ImmutableTable.copyOf(this.reviewersByEmail)));
                this.workInProgress = true;
            }
            return;
        }
        if (Boolean.FALSE.toString().equalsIgnoreCase(raw)) {
            this.previousWorkInProgressFooter = false;
            this.hasReviewStarted = true;
            if (this.workInProgress == null) {
                this.workInProgress = false;
            }
            return;
        }
        throw this.invalidFooter(ChangeNoteUtil.FOOTER_WORK_IN_PROGRESS, raw);
    }

    private Change.Id parseRevertOf(ChangeNotesCommit commit) throws ConfigInvalidException {
        String footer = this.parseOneFooter(commit, ChangeNoteUtil.FOOTER_REVERT_OF);
        if (footer == null) {
            return null;
        }
        Integer revertOf = Ints.tryParse(footer);
        if (revertOf == null) {
            throw this.invalidFooter(ChangeNoteUtil.FOOTER_REVERT_OF, footer);
        }
        return new Change.Id(revertOf);
    }

    private void pruneReviewers() {
        Iterator<Table.Cell<Account.Id, ReviewerStateInternal, Timestamp>> rit = this.reviewers.cellSet().iterator();
        while (rit.hasNext()) {
            Table.Cell<Account.Id, ReviewerStateInternal, Timestamp> e = rit.next();
            if (e.getColumnKey() != ReviewerStateInternal.REMOVED) continue;
            rit.remove();
        }
    }

    private void pruneReviewersByEmail() {
        Iterator<Table.Cell<Address, ReviewerStateInternal, Timestamp>> rit = this.reviewersByEmail.cellSet().iterator();
        while (rit.hasNext()) {
            Table.Cell<Address, ReviewerStateInternal, Timestamp> e = rit.next();
            if (e.getColumnKey() != ReviewerStateInternal.REMOVED) continue;
            rit.remove();
        }
    }

    private void updatePatchSetStates() {
        TreeSet<PatchSet.Id> missing = new TreeSet<PatchSet.Id>(ReviewDbUtil.intKeyOrdering());
        Iterator<Object> it = this.patchSets.values().iterator();
        while (it.hasNext()) {
            PatchSet patchSet = it.next();
            if (!patchSet.getRevision().equals(PARTIAL_PATCH_SET)) continue;
            missing.add(patchSet.getId());
            it.remove();
        }
        block4: for (Map.Entry entry : this.patchSetStates.entrySet()) {
            switch ((PatchSetState)((Object)entry.getValue())) {
                default: {
                    continue block4;
                }
                case DELETED: 
            }
            this.patchSets.remove(entry.getKey());
        }
        this.changeMessagesByPatchSet.keys().retainAll(this.patchSets.keySet());
        int pruned = this.pruneEntitiesForMissingPatchSets(this.allChangeMessages, ChangeMessage::getPatchSetId, missing);
        pruned += this.pruneEntitiesForMissingPatchSets(this.comments.values(), c -> new PatchSet.Id(this.id, c.key.patchSetId), missing);
        pruned += this.pruneEntitiesForMissingPatchSets(this.approvals.values(), PatchSetApproval::getPatchSetId, missing);
        if (!missing.isEmpty()) {
            log.warn("ignoring {} additional entities due to missing patch sets: {}", (Object)pruned, (Object)missing);
        }
    }

    private <T> int pruneEntitiesForMissingPatchSets(Iterable<T> ents, Function<T, PatchSet.Id> psIdFunc, Set<PatchSet.Id> missing) {
        int pruned = 0;
        Iterator<T> it = ents.iterator();
        while (it.hasNext()) {
            PatchSet.Id psId = psIdFunc.apply(it.next());
            if (!this.patchSets.containsKey(psId)) {
                ++pruned;
                missing.add(psId);
                it.remove();
                continue;
            }
            if (!this.deletedPatchSets.contains(psId)) continue;
            it.remove();
        }
        return pruned;
    }

    private void checkMandatoryFooters() throws ConfigInvalidException {
        ArrayList<FooterKey> missing = new ArrayList<FooterKey>();
        if (this.branch == null) {
            missing.add(ChangeNoteUtil.FOOTER_BRANCH);
        }
        if (this.changeId == null) {
            missing.add(ChangeNoteUtil.FOOTER_CHANGE_ID);
        }
        if (this.originalSubject == null || this.subject == null) {
            missing.add(ChangeNoteUtil.FOOTER_SUBJECT);
        }
        if (!missing.isEmpty()) {
            throw this.parseException("Missing footers: " + missing.stream().map(FooterKey::getName).collect(Collectors.joining(", ")), new Object[0]);
        }
    }

    private ConfigInvalidException expectedOneFooter(FooterKey footer, List<String> actual) {
        return this.parseException("missing or multiple %s: %s", footer.getName(), actual);
    }

    private ConfigInvalidException invalidFooter(FooterKey footer, String actual) {
        return this.parseException("invalid %s: %s", footer.getName(), actual);
    }

    private void checkFooter(boolean expr, FooterKey footer, String actual) throws ConfigInvalidException {
        if (!expr) {
            throw this.invalidFooter(footer, actual);
        }
    }

    private ConfigInvalidException parseException(String fmt, Object ... args) {
        return ChangeNotes.parseException(this.id, fmt, args);
    }

    @AutoValue
    static abstract class ApprovalKey {
        ApprovalKey() {
        }

        abstract PatchSet.Id psId();

        abstract Account.Id accountId();

        abstract String label();

        private static ApprovalKey create(PatchSet.Id psId, Account.Id accountId, String label) {
            return new AutoValue_ChangeNotesParser_ApprovalKey(psId, accountId, label);
        }
    }
}

