/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeRevisionNote;
import com.google.gerrit.server.notedb.NoteDbRewriter;
import com.google.gerrit.server.notedb.RevisionNoteBuilder;
import com.google.gerrit.server.notedb.RevisionNoteMap;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.CommitBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;

public class DeleteCommentRewriter
implements NoteDbRewriter {
    private final ChangeNoteUtil noteUtil;
    private final Change.Id changeId;
    private final String uuid;
    private final String newMessage;

    @Inject
    DeleteCommentRewriter(ChangeNoteUtil noteUtil, @Assisted Change.Id changeId, @Assisted(value="uuid") String uuid, @Assisted(value="newMessage") String newMessage) {
        this.noteUtil = noteUtil;
        this.changeId = changeId;
        this.uuid = uuid;
        this.newMessage = newMessage;
    }

    @Override
    public String getRefName() {
        return RefNames.changeMetaRef(this.changeId);
    }

    @Override
    public ObjectId rewriteCommitHistory(RevWalk revWalk, ObjectInserter inserter, ObjectId currTip) throws IOException, ConfigInvalidException, OrmException {
        RevCommit originalCommit;
        Preconditions.checkArgument(!currTip.equals(ObjectId.zeroId()));
        revWalk.reset();
        revWalk.markStart(revWalk.parseCommit(currTip));
        revWalk.sort(RevSort.REVERSE);
        ObjectReader reader = revWalk.getObjectReader();
        RevCommit newTipCommit = revWalk.next();
        Map<String, Comment> parentComments = DeleteCommentRewriter.getPublishedComments(this.noteUtil, this.changeId, reader, NoteMap.read(reader, newTipCommit));
        boolean rewrite = false;
        while ((originalCommit = revWalk.next()) != null) {
            NoteMap noteMap = NoteMap.read(reader, originalCommit);
            Map<String, Comment> currComments = DeleteCommentRewriter.getPublishedComments(this.noteUtil, this.changeId, reader, noteMap);
            if (!rewrite && currComments.containsKey(this.uuid)) {
                rewrite = true;
            }
            if (!rewrite) {
                parentComments = currComments;
                newTipCommit = originalCommit;
                continue;
            }
            List<Comment> putInComments = this.getPutInComments(parentComments, currComments);
            List<Comment> deletedComments = this.getDeletedComments(parentComments, currComments);
            newTipCommit = revWalk.parseCommit(this.rewriteCommit(originalCommit, newTipCommit, inserter, reader, putInComments, deletedComments));
            parentComments = currComments;
        }
        return newTipCommit;
    }

    @VisibleForTesting
    public static Map<String, Comment> getPublishedComments(ChangeNoteUtil noteUtil, Change.Id changeId, ObjectReader reader, NoteMap noteMap) throws IOException, ConfigInvalidException {
        return RevisionNoteMap.parse((ChangeNoteUtil)noteUtil, (Change.Id)changeId, (ObjectReader)reader, (NoteMap)noteMap, (PatchLineComment.Status)PatchLineComment.Status.PUBLISHED).revisionNotes.values().stream().flatMap(n -> n.getComments().stream()).collect(Collectors.toMap(c -> c.key.uuid, c -> c));
    }

    private List<Comment> getPutInComments(Map<String, Comment> parMap, Map<String, Comment> curMap) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (String key : curMap.keySet()) {
            if (parMap.containsKey(key)) continue;
            Comment comment = curMap.get(key);
            if (key.equals(this.uuid)) {
                comment.message = this.newMessage;
            }
            comments.add(comment);
        }
        return comments;
    }

    private List<Comment> getDeletedComments(Map<String, Comment> parMap, Map<String, Comment> curMap) {
        return parMap.entrySet().stream().filter(c -> !curMap.containsKey(c.getKey())).map(c -> (Comment)c.getValue()).collect(Collectors.toList());
    }

    private ObjectId rewriteCommit(RevCommit originalCommit, RevCommit parentCommit, ObjectInserter inserter, ObjectReader reader, List<Comment> putInComments, List<Comment> deletedComments) throws IOException, ConfigInvalidException {
        RevisionNoteMap<ChangeRevisionNote> revNotesMap = RevisionNoteMap.parse(this.noteUtil, this.changeId, reader, NoteMap.read(reader, parentCommit), PatchLineComment.Status.PUBLISHED);
        RevisionNoteBuilder.Cache cache = new RevisionNoteBuilder.Cache(revNotesMap);
        for (Comment comment : putInComments) {
            cache.get(new RevId(comment.revId)).putComment(comment);
        }
        for (Comment comment : deletedComments) {
            cache.get(new RevId(comment.revId)).deleteComment(comment.key);
        }
        Map<RevId, RevisionNoteBuilder> builders = cache.getBuilders();
        for (Map.Entry<RevId, RevisionNoteBuilder> entry : builders.entrySet()) {
            ObjectId objectId = ObjectId.fromString(entry.getKey().get());
            byte[] data = entry.getValue().build(this.noteUtil, this.noteUtil.getWriteJson());
            if (data.length == 0) {
                revNotesMap.noteMap.remove(objectId);
                continue;
            }
            revNotesMap.noteMap.set(objectId, inserter.insert(3, data));
        }
        CommitBuilder commitBuilder = new CommitBuilder();
        commitBuilder.setParentId(parentCommit);
        commitBuilder.setTreeId(revNotesMap.noteMap.writeTree(inserter));
        commitBuilder.setMessage(originalCommit.getFullMessage());
        commitBuilder.setCommitter(originalCommit.getCommitterIdent());
        commitBuilder.setAuthor(originalCommit.getAuthorIdent());
        commitBuilder.setEncoding(originalCommit.getEncoding());
        return inserter.insert(commitBuilder);
    }

    public static interface Factory {
        public DeleteCommentRewriter create(Change.Id var1, @Assisted(value="uuid") String var2, @Assisted(value="newMessage") String var3);
    }
}

