/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class DelegatingClassLoader
extends ClassLoader {
    private final ClassLoader target;

    public DelegatingClassLoader(ClassLoader parent, ClassLoader target) {
        super(parent);
        this.target = target;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        block20: {
            String path = name.replace('.', '/') + ".class";
            try {
                Throwable throwable = null;
                try (InputStream resource = this.target.getResourceAsStream(path);){
                    if (resource != null) {
                        try {
                            byte[] bytes = ByteStreams.toByteArray(resource);
                            Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                            return clazz;
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        URL rtn = this.getParent().getResource(name);
        if (rtn == null) {
            rtn = this.target.getResource(name);
        }
        return rtn;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> rtn = this.getParent().getResources(name);
        if (rtn == null) {
            rtn = this.target.getResources(name);
        }
        return rtn;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream rtn = this.getParent().getResourceAsStream(name);
        if (rtn == null) {
            rtn = this.target.getResourceAsStream(name);
        }
        return rtn;
    }
}

