/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.plugins;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestCollection;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.plugins.InstallPlugin;
import com.google.gerrit.server.plugins.ListPlugins;
import com.google.gerrit.server.plugins.Plugin;
import com.google.gerrit.server.plugins.PluginLoader;
import com.google.gerrit.server.plugins.PluginResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class PluginsCollection
implements RestCollection<TopLevelResource, PluginResource>,
AcceptsCreate<TopLevelResource> {
    private final DynamicMap<RestView<PluginResource>> views;
    private final PluginLoader loader;
    private final Provider<ListPlugins> list;
    private final Provider<InstallPlugin> install;

    @Inject
    PluginsCollection(DynamicMap<RestView<PluginResource>> views, PluginLoader loader, Provider<ListPlugins> list, Provider<InstallPlugin> install) {
        this.views = views;
        this.loader = loader;
        this.list = list;
        this.install = install;
    }

    @Override
    public RestView<TopLevelResource> list() throws ResourceNotFoundException {
        return this.list.get();
    }

    @Override
    public PluginResource parse(TopLevelResource parent, IdString id) throws ResourceNotFoundException {
        return this.parse(id.get());
    }

    public PluginResource parse(String id) throws ResourceNotFoundException {
        Plugin p = this.loader.get(id);
        if (p == null) {
            throw new ResourceNotFoundException(id);
        }
        return new PluginResource(p);
    }

    public InstallPlugin create(TopLevelResource parent, IdString id) throws ResourceNotFoundException, MethodNotAllowedException {
        if (!this.loader.isRemoteAdminEnabled()) {
            throw new MethodNotAllowedException("remote installation is disabled");
        }
        return this.install.get().setName(id.get()).setCreated(true);
    }

    @Override
    public DynamicMap<RestView<PluginResource>> views() {
        return this.views;
    }
}

