/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jgit.lib.Config;

@Singleton
public class ProjectCacheClock
implements LifecycleListener {
    private final Config serverConfig;
    private final AtomicLong generation = new AtomicLong();
    private ScheduledExecutorService executor;

    @Inject
    public ProjectCacheClock(@GerritServerConfig Config serverConfig) {
        this.serverConfig = serverConfig;
    }

    @Override
    public void start() {
        long checkFrequencyMillis = ProjectCacheClock.checkFrequency(this.serverConfig);
        if (checkFrequencyMillis == Long.MAX_VALUE) {
            this.generation.set(1L);
        } else if (10L < checkFrequencyMillis) {
            this.generation.set(1L);
            this.executor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("ProjectCacheClock-%d").setDaemon(true).setPriority(1).build());
            ScheduledFuture<?> scheduledFuture = this.executor.scheduleAtFixedRate(() -> this.generation.incrementAndGet(), checkFrequencyMillis, checkFrequencyMillis, TimeUnit.MILLISECONDS);
        } else {
            this.generation.set(0L);
        }
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    long read() {
        return this.generation.get();
    }

    private static long checkFrequency(Config serverConfig) {
        String freq = serverConfig.getString("cache", "projects", "checkFrequency");
        if (freq != null && ("disabled".equalsIgnoreCase(freq) || "off".equalsIgnoreCase(freq))) {
            return Long.MAX_VALUE;
        }
        return TimeUnit.MILLISECONDS.convert(ConfigUtil.getTimeUnit(serverConfig, "cache", "projects", "checkFrequency", 5L, TimeUnit.MINUTES), TimeUnit.MINUTES);
    }
}

