/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.account;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.gerrit.index.query.LimitPredicate;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.index.query.QueryBuilder;
import com.google.gerrit.index.query.QueryParseException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeFinder;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.query.account.AccountPredicates;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;

public class AccountQueryBuilder
extends QueryBuilder<AccountState> {
    public static final String FIELD_ACCOUNT = "account";
    public static final String FIELD_EMAIL = "email";
    public static final String FIELD_LIMIT = "limit";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_PREFERRED_EMAIL = "preferredemail";
    public static final String FIELD_PREFERRED_EMAIL_EXACT = "preferredemail_exact";
    public static final String FIELD_USERNAME = "username";
    public static final String FIELD_VISIBLETO = "visibleto";
    private static final QueryBuilder.Definition<AccountState, AccountQueryBuilder> mydef = new QueryBuilder.Definition(AccountQueryBuilder.class);
    private final Arguments args;

    @Inject
    AccountQueryBuilder(Arguments args) {
        super(mydef);
        this.args = args;
    }

    @QueryBuilder.Operator
    public Predicate<AccountState> cansee(String change) throws QueryParseException, OrmException, PermissionBackendException {
        ChangeNotes changeNotes = this.args.changeFinder.findOne(change);
        if (changeNotes == null || !((PermissionBackend.WithUser)this.args.permissionBackend.user(this.args.getUser()).database(this.args.db)).change(changeNotes).test(ChangePermission.READ)) {
            throw AccountQueryBuilder.error(String.format("change %s not found", change));
        }
        return AccountPredicates.cansee(this.args, changeNotes);
    }

    @QueryBuilder.Operator
    public Predicate<AccountState> email(String email) {
        return AccountPredicates.email(email);
    }

    @QueryBuilder.Operator
    public Predicate<AccountState> is(String value) throws QueryParseException {
        if ("active".equalsIgnoreCase(value)) {
            return AccountPredicates.isActive();
        }
        if ("inactive".equalsIgnoreCase(value)) {
            return AccountPredicates.isNotActive();
        }
        throw AccountQueryBuilder.error("Invalid query");
    }

    @QueryBuilder.Operator
    public Predicate<AccountState> limit(String query) throws QueryParseException {
        Integer limit = Ints.tryParse(query);
        if (limit == null) {
            throw AccountQueryBuilder.error("Invalid limit: " + query);
        }
        return new LimitPredicate<AccountState>(FIELD_LIMIT, limit);
    }

    @QueryBuilder.Operator
    public Predicate<AccountState> name(String name) {
        return AccountPredicates.equalsName(name);
    }

    @QueryBuilder.Operator
    public Predicate<AccountState> username(String username) {
        return AccountPredicates.username(username);
    }

    public Predicate<AccountState> defaultQuery(String query) {
        return Predicate.and(Lists.transform(Splitter.on(' ').omitEmptyStrings().splitToList(query), this::defaultField));
    }

    @Override
    protected Predicate<AccountState> defaultField(String query) {
        Predicate<AccountState> defaultPredicate = AccountPredicates.defaultPredicate(query);
        if (query.startsWith("cansee:")) {
            try {
                return this.cansee(query.substring(7));
            }
            catch (QueryParseException | PermissionBackendException | OrmException exception) {
                // empty catch block
            }
        }
        if ("self".equalsIgnoreCase(query) || "me".equalsIgnoreCase(query)) {
            try {
                return Predicate.or(defaultPredicate, AccountPredicates.id(this.self()));
            }
            catch (QueryParseException queryParseException) {
                // empty catch block
            }
        }
        return defaultPredicate;
    }

    private Account.Id self() throws QueryParseException {
        return this.args.getIdentifiedUser().getAccountId();
    }

    public static class Arguments {
        final Provider<ReviewDb> db;
        final ChangeFinder changeFinder;
        final IdentifiedUser.GenericFactory userFactory;
        final PermissionBackend permissionBackend;
        private final Provider<CurrentUser> self;

        @Inject
        public Arguments(Provider<CurrentUser> self, Provider<ReviewDb> db, ChangeFinder changeFinder, IdentifiedUser.GenericFactory userFactory, PermissionBackend permissionBackend) {
            this.self = self;
            this.db = db;
            this.changeFinder = changeFinder;
            this.userFactory = userFactory;
            this.permissionBackend = permissionBackend;
        }

        IdentifiedUser getIdentifiedUser() throws QueryParseException {
            try {
                CurrentUser u = this.getUser();
                if (u.isIdentifiedUser()) {
                    return u.asIdentifiedUser();
                }
                throw new QueryParseException("Not Signed In");
            }
            catch (ProvisionException e) {
                throw new QueryParseException("Not Signed In", e);
            }
        }

        CurrentUser getUser() throws QueryParseException {
            try {
                return this.self.get();
            }
            catch (ProvisionException e) {
                throw new QueryParseException("Not Signed In", e);
            }
        }
    }
}

