/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class IsReviewedPredicate
extends ChangeIndexPredicate {
    protected static final Account.Id NOT_REVIEWED = new Account.Id(ChangeField.NOT_REVIEWED);
    protected final Account.Id id;

    public static Predicate<ChangeData> create() {
        return Predicate.not(new IsReviewedPredicate(NOT_REVIEWED));
    }

    public static Predicate<ChangeData> create(Collection<Account.Id> ids) {
        ArrayList<IsReviewedPredicate> predicates = new ArrayList<IsReviewedPredicate>(ids.size());
        for (Account.Id id : ids) {
            predicates.add(new IsReviewedPredicate(id));
        }
        return Predicate.or(predicates);
    }

    private IsReviewedPredicate(Account.Id id) {
        super(ChangeField.REVIEWEDBY, Integer.toString(id.get()));
        this.id = id;
    }

    @Override
    public boolean match(ChangeData cd) throws OrmException {
        Set<Account.Id> reviewedBy = cd.reviewedBy();
        return !reviewedBy.isEmpty() ? reviewedBy.contains(this.id) : this.id.equals(NOT_REVIEWED);
    }

    @Override
    public int getCost() {
        return 1;
    }
}

