/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeOperatorPredicate;
import com.google.gwtorm.server.OrmException;

public class ReviewerinPredicate
extends ChangeOperatorPredicate {
    protected final IdentifiedUser.GenericFactory userFactory;
    protected final AccountGroup.UUID uuid;

    public ReviewerinPredicate(IdentifiedUser.GenericFactory userFactory, AccountGroup.UUID uuid) {
        super("reviewerin", uuid.toString());
        this.userFactory = userFactory;
        this.uuid = uuid;
    }

    protected AccountGroup.UUID getAccountGroupUUID() {
        return this.uuid;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        for (Account.Id accountId : object.reviewers().byState(ReviewerStateInternal.REVIEWER)) {
            IdentifiedUser reviewer = this.userFactory.create(accountId);
            if (!reviewer.getEffectiveGroups().contains(this.uuid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCost() {
        return 3;
    }
}

