/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_122;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.jdbc.JdbcSchema;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

public class Schema_123
extends SchemaVersion {
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsersName;

    @Inject
    Schema_123(Provider<Schema_122> prior, GitRepositoryManager repoManager, AllUsersName allUsersName) {
        super(prior);
        this.repoManager = repoManager;
        this.allUsersName = allUsersName;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException, SQLException {
        Throwable throwable;
        Multimap imports = MultimapBuilder.hashKeys().arrayListValues().build();
        try (Statement stmt = ((JdbcSchema)((Object)db)).getConnection().createStatement();){
            throwable = null;
            try (ResultSet rs = stmt.executeQuery("SELECT account_id, change_id FROM starred_changes");){
                while (rs.next()) {
                    Account.Id accountId = new Account.Id(rs.getInt(1));
                    Change.Id changeId = new Change.Id(rs.getInt(2));
                    imports.put(accountId, changeId);
                }
            }
            catch (Throwable accountId) {
                throwable = accountId;
                throw accountId;
            }
        }
        if (imports.isEmpty()) {
            return;
        }
        try {
            var5_6 = null;
            try (Repository git = this.repoManager.openRepository(this.allUsersName);){
                throwable = null;
                try (RevWalk rw = new RevWalk(git);){
                    BatchRefUpdate bru = git.getRefDatabase().newBatchUpdate();
                    ObjectId id = StarredChangesUtil.writeLabels(git, StarredChangesUtil.DEFAULT_LABELS);
                    for (Map.Entry e : imports.entries()) {
                        bru.addCommand(new ReceiveCommand(ObjectId.zeroId(), id, RefNames.refsStarredChanges((Change.Id)e.getValue(), (Account.Id)e.getKey())));
                    }
                    bru.execute(rw, new TextProgressMonitor());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                var5_6 = throwable3;
                throw throwable3;
            }
        }
        catch (StarredChangesUtil.IllegalLabelException | IOException ex) {
            throw new OrmException(ex);
        }
    }
}

