/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.update;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.metrics.Description;
import com.google.gerrit.metrics.Field;
import com.google.gerrit.metrics.MetricMaker;
import com.google.gerrit.metrics.Timer1;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbWrapper;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.InsertedObject;
import com.google.gerrit.server.git.LockFailureException;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NoteDbUpdateManager;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateListener;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.BatchUpdateReviewDb;
import com.google.gerrit.server.update.ChainedReceiveCommands;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.ChangeUpdateExecutor;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.Order;
import com.google.gerrit.server.update.RepoContext;
import com.google.gerrit.server.update.RepoOnlyOp;
import com.google.gerrit.server.update.RepoView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gerrit.server.util.RequestId;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReviewDbBatchUpdate
extends BatchUpdate {
    private static final Logger log = LoggerFactory.getLogger(ReviewDbBatchUpdate.class);
    private final AllUsersName allUsers;
    private final ChangeIndexer indexer;
    private final ChangeNotes.Factory changeNotesFactory;
    private final ChangeUpdate.Factory changeUpdateFactory;
    private final GitReferenceUpdated gitRefUpdated;
    private final ListeningExecutorService changeUpdateExector;
    private final Metrics metrics;
    private final NoteDbUpdateManager.Factory updateManagerFactory;
    private final NotesMigration notesMigration;
    private final ReviewDb db;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final long skewMs;
    private final List<CheckedFuture<?, IOException>> indexFutures = new ArrayList();

    static void execute(ImmutableList<ReviewDbBatchUpdate> updates, BatchUpdateListener listener, @Nullable RequestId requestId, boolean dryrun) throws UpdateException, RestApiException {
        if (updates.isEmpty()) {
            return;
        }
        ReviewDbBatchUpdate.setRequestIds(updates, requestId);
        try {
            Order order = ReviewDbBatchUpdate.getOrder(updates, listener);
            boolean updateChangesInParallel = ReviewDbBatchUpdate.getUpdateChangesInParallel(updates);
            switch (order) {
                case REPO_BEFORE_DB: {
                    for (ReviewDbBatchUpdate u2 : updates) {
                        u2.executeUpdateRepo();
                    }
                    listener.afterUpdateRepos();
                    for (ReviewDbBatchUpdate u2 : updates) {
                        u2.executeRefUpdates(dryrun);
                    }
                    listener.afterUpdateRefs();
                    for (ReviewDbBatchUpdate u2 : updates) {
                        u2.reindexChanges(u2.executeChangeOps(updateChangesInParallel, dryrun));
                    }
                    listener.afterUpdateChanges();
                    break;
                }
                case DB_BEFORE_REPO: {
                    for (ReviewDbBatchUpdate u2 : updates) {
                        u2.reindexChanges(u2.executeChangeOps(updateChangesInParallel, dryrun));
                    }
                    for (ReviewDbBatchUpdate u2 : updates) {
                        u2.executeUpdateRepo();
                    }
                    for (ReviewDbBatchUpdate u2 : updates) {
                        u2.executeRefUpdates(dryrun);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid execution order: " + (Object)((Object)order));
                }
            }
            ChangeIndexer.allAsList(updates.stream().flatMap(u -> u.indexFutures.stream()).collect(Collectors.toList())).get();
            updates.stream().filter(u -> u.batchRefUpdate != null).forEach(u -> u.gitRefUpdated.fire(u.project, u.batchRefUpdate, (Account)u.getAccount().orElse(null)));
            if (!dryrun) {
                for (ReviewDbBatchUpdate u2 : updates) {
                    u2.executePostOps();
                }
            }
        }
        catch (Exception e) {
            ReviewDbBatchUpdate.wrapAndThrowException(e);
        }
    }

    @Inject
    ReviewDbBatchUpdate(@GerritServerConfig Config cfg, AllUsersName allUsers, ChangeIndexer indexer, ChangeNotes.Factory changeNotesFactory, @ChangeUpdateExecutor ListeningExecutorService changeUpdateExector, ChangeUpdate.Factory changeUpdateFactory, @GerritPersonIdent PersonIdent serverIdent, GitReferenceUpdated gitRefUpdated, GitRepositoryManager repoManager, Metrics metrics, NoteDbUpdateManager.Factory updateManagerFactory, NotesMigration notesMigration, SchemaFactory<ReviewDb> schemaFactory, @Assisted ReviewDb db, @Assisted Project.NameKey project, @Assisted CurrentUser user, @Assisted Timestamp when) {
        super(repoManager, serverIdent, project, user, when);
        this.allUsers = allUsers;
        this.changeNotesFactory = changeNotesFactory;
        this.changeUpdateExector = changeUpdateExector;
        this.changeUpdateFactory = changeUpdateFactory;
        this.gitRefUpdated = gitRefUpdated;
        this.indexer = indexer;
        this.metrics = metrics;
        this.notesMigration = notesMigration;
        this.schemaFactory = schemaFactory;
        this.updateManagerFactory = updateManagerFactory;
        this.db = db;
        this.skewMs = NoteDbChangeState.getReadOnlySkew(cfg);
    }

    @Override
    public void execute(BatchUpdateListener listener) throws UpdateException, RestApiException {
        ReviewDbBatchUpdate.execute(ImmutableList.of(this), listener, this.requestId, false);
    }

    @Override
    protected Context newContext() {
        return new ContextImpl();
    }

    private void executeUpdateRepo() throws UpdateException, RestApiException {
        try {
            this.logDebug("Executing updateRepo on {} ops", this.ops.size());
            RepoContextImpl ctx = new RepoContextImpl();
            for (RepoOnlyOp op : this.ops.values()) {
                op.updateRepo(ctx);
            }
            this.logDebug("Executing updateRepo on {} RepoOnlyOps", this.repoOnlyOps.size());
            for (RepoOnlyOp op : this.repoOnlyOps) {
                op.updateRepo(ctx);
            }
            if (this.onSubmitValidators != null && !this.getRefUpdates().isEmpty()) {
                this.onSubmitValidators.validate(this.project, ctx.getRevWalk().getObjectReader(), this.repoView.getCommands());
            }
            if (this.repoView != null) {
                this.logDebug("Flushing inserter", new Object[0]);
                this.repoView.getInserter().flush();
            } else {
                this.logDebug("No objects to flush", new Object[0]);
            }
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf(e, RestApiException.class);
            throw new UpdateException(e);
        }
    }

    private void executeRefUpdates(boolean dryrun) throws IOException, RestApiException {
        if (this.getRefUpdates().isEmpty()) {
            this.logDebug("No ref updates to execute", new Object[0]);
            return;
        }
        this.initRepository();
        this.batchRefUpdate = this.repoView.getRepository().getRefDatabase().newBatchUpdate();
        this.batchRefUpdate.setPushCertificate(this.pushCert);
        this.batchRefUpdate.setRefLogMessage(this.refLogMessage, true);
        this.batchRefUpdate.setAllowNonFastForwards(true);
        this.repoView.getCommands().addTo(this.batchRefUpdate);
        if (this.user.isIdentifiedUser()) {
            this.batchRefUpdate.setRefLogIdent(this.user.asIdentifiedUser().newRefLogIdent(this.when, this.tz));
        }
        this.logDebug("Executing batch of {} ref updates", this.batchRefUpdate.getCommands().size());
        if (dryrun) {
            return;
        }
        RevWalk updateRw = new RevWalk(this.repoView.getRepository());
        Object object = null;
        try {
            this.batchRefUpdate.execute(updateRw, NullProgressMonitor.INSTANCE);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            ReviewDbBatchUpdate.$closeResource((Throwable)object, updateRw);
        }
        boolean ok = true;
        for (ReceiveCommand cmd : this.batchRefUpdate.getCommands()) {
            if (cmd.getResult() == ReceiveCommand.Result.OK) continue;
            ok = false;
            break;
        }
        if (!ok) {
            throw new RestApiException("BatchRefUpdate failed: " + this.batchRefUpdate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ChangeTask> executeChangeOps(boolean parallel, boolean dryrun) throws UpdateException, RestApiException {
        ArrayList<ChangeTask> tasks;
        boolean success = false;
        Stopwatch sw = Stopwatch.createStarted();
        try {
            this.logDebug("Executing change ops (parallel? {})", parallel);
            ListeningExecutorService executor = parallel ? this.changeUpdateExector : MoreExecutors.newDirectExecutorService();
            tasks = new ArrayList<ChangeTask>(this.ops.keySet().size());
            try {
                if (this.notesMigration.commitChangeWrites() && this.repoView != null) {
                    this.logDebug("Preemptively scanning for repo changes", new Object[0]);
                    this.repoView.getRepository().scanForRepoChanges();
                }
                if (!this.ops.isEmpty() && this.notesMigration.failChangeWrites()) {
                    this.logDebug("Failing early due to read-only Changes table", new Object[0]);
                    throw new OrmException("NoteDb changes are read-only");
                }
                ArrayList<Future> futures = new ArrayList<Future>(this.ops.keySet().size());
                for (Map.Entry e : this.ops.asMap().entrySet()) {
                    ChangeTask task = new ChangeTask((Change.Id)e.getKey(), e.getValue(), Thread.currentThread(), dryrun);
                    tasks.add(task);
                    if (!parallel) {
                        this.logDebug("Direct execution of task for ops: {}", this.ops);
                    }
                    futures.add(executor.submit((Callable)task));
                }
                if (parallel) {
                    this.logDebug("Waiting on futures for {} ops spanning {} changes", this.ops.size(), this.ops.keySet().size());
                }
                Futures.allAsList(futures).get();
                if (this.notesMigration.commitChangeWrites() && !dryrun) {
                    this.executeNoteDbUpdates(tasks);
                }
                success = true;
            }
            catch (InterruptedException | ExecutionException e) {
                Throwables.throwIfInstanceOf(e.getCause(), UpdateException.class);
                Throwables.throwIfInstanceOf(e.getCause(), RestApiException.class);
                throw new UpdateException(e);
            }
            catch (OrmException | IOException e) {
                throw new UpdateException(e);
            }
        }
        finally {
            this.metrics.executeChangeOpsLatency.record(success, sw.elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        }
        return tasks;
    }

    private void reindexChanges(List<ChangeTask> tasks) {
        for (ChangeTask task : tasks) {
            if (task.deleted) {
                this.indexFutures.add(this.indexer.deleteAsync(task.id));
                continue;
            }
            if (!task.dirty) continue;
            this.indexFutures.add(this.indexer.indexAsync(this.project, task.id));
        }
    }

    private void executeNoteDbUpdates(List<ChangeTask> tasks) throws ResourceConflictException, IOException {
        block37: {
            this.logDebug("Executing NoteDb updates for {} changes", tasks.size());
            try {
                this.initRepository();
                BatchRefUpdate changeRefUpdate = this.repoView.getRepository().getRefDatabase().newBatchUpdate();
                boolean hasAllUsersCommands = false;
                try (ObjectInserter ins = this.repoView.getRepository().newObjectInserter();){
                    int objs = 0;
                    for (ChangeTask task : tasks) {
                        if (task.noteDbResult == null) {
                            this.logDebug("No-op update to {}", task.id);
                            continue;
                        }
                        for (ReceiveCommand cmd : task.noteDbResult.changeCommands()) {
                            changeRefUpdate.addCommand(cmd);
                        }
                        for (InsertedObject obj : task.noteDbResult.changeObjects()) {
                            ++objs;
                            ins.insert(obj.type(), obj.data().toByteArray());
                        }
                        hasAllUsersCommands |= !task.noteDbResult.allUsersCommands().isEmpty();
                    }
                    this.logDebug("Collected {} objects and {} ref updates to change repo", objs, changeRefUpdate.getCommands().size());
                    this.executeNoteDbUpdate(this.getRevWalk(), ins, changeRefUpdate);
                }
                if (hasAllUsersCommands) {
                    var5_6 = null;
                    try (Repository allUsersRepo = this.repoManager.openRepository(this.allUsers);){
                        RevWalk allUsersRw = new RevWalk(allUsersRepo);
                        Object object = null;
                        try {
                            ObjectInserter allUsersIns = allUsersRepo.newObjectInserter();
                            Object object2 = null;
                            try {
                                int objs = 0;
                                BatchRefUpdate allUsersRefUpdate = allUsersRepo.getRefDatabase().newBatchUpdate();
                                for (ChangeTask task : tasks) {
                                    for (ReceiveCommand cmd : task.noteDbResult.allUsersCommands()) {
                                        allUsersRefUpdate.addCommand(cmd);
                                    }
                                    for (InsertedObject obj : task.noteDbResult.allUsersObjects()) {
                                        allUsersIns.insert(obj.type(), obj.data().toByteArray());
                                    }
                                }
                                this.logDebug("Collected {} objects and {} ref updates to All-Users", objs, allUsersRefUpdate.getCommands().size());
                                this.executeNoteDbUpdate(allUsersRw, allUsersIns, allUsersRefUpdate);
                            }
                            catch (Throwable throwable) {
                                object2 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (allUsersIns != null) {
                                    ReviewDbBatchUpdate.$closeResource((Throwable)object2, allUsersIns);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                object = throwable;
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                ReviewDbBatchUpdate.$closeResource(object, allUsersRw);
                                throw throwable2;
                            }
                        }
                        ReviewDbBatchUpdate.$closeResource((Throwable)object, allUsersRw);
                        break block37;
                    }
                    catch (Throwable throwable) {
                        var5_6 = throwable;
                        throw throwable;
                    }
                }
                this.logDebug("No All-Users updates", new Object[0]);
            }
            catch (IOException e) {
                if (tasks.stream().allMatch(t -> t.storage == NoteDbChangeState.PrimaryStorage.REVIEW_DB)) {
                    log.debug("Ignoring NoteDb update error after ReviewDb write", e);
                } else if (e instanceof LockFailureException) {
                    throw new ResourceConflictException("Updating change failed due to conflicting write", e);
                }
                throw e;
            }
        }
    }

    private void executeNoteDbUpdate(RevWalk rw, ObjectInserter ins, BatchRefUpdate bru) throws IOException {
        if (bru.getCommands().isEmpty()) {
            this.logDebug("No commands, skipping flush and ref update", new Object[0]);
            return;
        }
        ins.flush();
        bru.setAllowNonFastForwards(true);
        bru.execute(rw, NullProgressMonitor.INSTANCE);
        for (ReceiveCommand cmd : bru.getCommands()) {
            if (cmd.getResult() == ReceiveCommand.Result.OK) continue;
            throw new IOException("Update failed: " + bru);
        }
    }

    private static Iterable<Change> changesToUpdate(ChangeContextImpl ctx) {
        Change c = ctx.getChange();
        if (ctx.bumpLastUpdatedOn && c.getLastUpdatedOn().before(ctx.getWhen())) {
            c.setLastUpdatedOn(ctx.getWhen());
        }
        return Collections.singleton(c);
    }

    private void executePostOps() throws Exception {
        ContextImpl ctx = new ContextImpl();
        for (RepoOnlyOp op : this.ops.values()) {
            op.postUpdate(ctx);
        }
        for (RepoOnlyOp op : this.repoOnlyOps) {
            op.postUpdate(ctx);
        }
    }

    private class ChangeTask
    implements Callable<Void> {
        final Change.Id id;
        private final Collection<BatchUpdateOp> changeOps;
        private final Thread mainThread;
        private final boolean dryrun;
        NoteDbChangeState.PrimaryStorage storage;
        NoteDbUpdateManager.StagedResult noteDbResult;
        boolean dirty;
        boolean deleted;
        private String taskId;

        private ChangeTask(Change.Id id, Collection<BatchUpdateOp> changeOps, Thread mainThread, boolean dryrun) {
            this.id = id;
            this.changeOps = changeOps;
            this.mainThread = mainThread;
            this.dryrun = dryrun;
        }

        @Override
        public Void call() throws Exception {
            this.taskId = this.id.toString() + "-" + Thread.currentThread().getId();
            if (Thread.currentThread() == this.mainThread) {
                ReviewDbBatchUpdate.this.initRepository();
                Repository repo = ReviewDbBatchUpdate.this.repoView.getRepository();
                try (RevWalk rw = new RevWalk(repo);){
                    this.call(ReviewDbBatchUpdate.this.db, repo, rw);
                }
            }
            try (ReviewDb threadLocalDb = (ReviewDb)ReviewDbBatchUpdate.this.schemaFactory.open();
                 Repository repo = ReviewDbBatchUpdate.this.repoManager.openRepository(ReviewDbBatchUpdate.this.project);
                 RevWalk rw = new RevWalk(repo);){
                this.call(threadLocalDb, repo, rw);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void call(ReviewDb db, Repository repo, RevWalk rw) throws Exception {
            try (NoteDbUpdateManager updateManager = null;){
                db.changes().beginTransaction(this.id);
                try {
                    ChangeContextImpl ctx = this.newChangeContext(db, repo, rw, this.id);
                    NoteDbChangeState oldState = NoteDbChangeState.parse(ctx.getChange());
                    NoteDbChangeState.checkNotReadOnly(oldState, ReviewDbBatchUpdate.this.skewMs);
                    this.storage = NoteDbChangeState.PrimaryStorage.of(oldState);
                    if (this.storage == NoteDbChangeState.PrimaryStorage.NOTE_DB && !ReviewDbBatchUpdate.this.notesMigration.readChanges()) {
                        throw new OrmException("must have NoteDb enabled to update change " + this.id);
                    }
                    this.logDebug("Calling updateChange on {} ops", this.changeOps.size());
                    for (BatchUpdateOp op : this.changeOps) {
                        this.dirty |= op.updateChange(ctx);
                    }
                    if (!this.dirty) {
                        this.logDebug("No ops reported dirty, short-circuiting", new Object[0]);
                        return;
                    }
                    this.deleted = ctx.deleted;
                    if (this.deleted) {
                        this.logDebug("Change was deleted", new Object[0]);
                    }
                    if (ReviewDbBatchUpdate.this.notesMigration.commitChangeWrites()) {
                        updateManager = this.stageNoteDbUpdate(ctx, this.deleted);
                    }
                    if (this.storage == NoteDbChangeState.PrimaryStorage.REVIEW_DB) {
                        Iterable cs = ReviewDbBatchUpdate.changesToUpdate(ctx);
                        if (this.isNewChange(this.id)) {
                            this.logDebug("Inserting change", new Object[0]);
                            db.changes().insert(cs);
                        } else if (this.deleted) {
                            this.logDebug("Deleting change", new Object[0]);
                            db.changes().delete(cs);
                        } else {
                            this.logDebug("Updating change", new Object[0]);
                            db.changes().update(cs);
                        }
                        if (!this.dryrun) {
                            db.commit();
                        }
                    } else {
                        this.logDebug("Skipping ReviewDb write since primary storage is {}", new Object[]{this.storage});
                    }
                }
                finally {
                    db.rollback();
                }
                if (this.storage == NoteDbChangeState.PrimaryStorage.NOTE_DB) {
                    Preconditions.checkState(ReviewDbBatchUpdate.this.notesMigration.commitChangeWrites());
                    this.noteDbResult = updateManager.stage().get(this.id);
                } else if (ReviewDbBatchUpdate.this.notesMigration.commitChangeWrites()) {
                    try {
                        this.noteDbResult = updateManager.stage().get(this.id);
                    }
                    catch (IOException ex) {
                        log.debug("Ignoring NoteDb update error after ReviewDb write", ex);
                    }
                }
            }
        }

        private ChangeContextImpl newChangeContext(ReviewDb db, Repository repo, RevWalk rw, Change.Id id) throws OrmException {
            boolean isNew;
            Change c = (Change)ReviewDbBatchUpdate.this.newChanges.get(id);
            boolean bl = isNew = c != null;
            if (isNew) {
                Preconditions.checkState(c.getNoteDbState() == null, "noteDbState should not be filled in by callers");
                if (ReviewDbBatchUpdate.this.notesMigration.changePrimaryStorage() == NoteDbChangeState.PrimaryStorage.NOTE_DB) {
                    c.setNoteDbState("N");
                }
            } else {
                c = ChangeNotes.readOneReviewDbChange(db, id);
                if (c == null) {
                    c = ChangeNotes.Factory.newNoteDbOnlyChange(ReviewDbBatchUpdate.this.project, id);
                }
                NoteDbChangeState.checkNotReadOnly(c, ReviewDbBatchUpdate.this.skewMs);
            }
            ChangeNotes notes = ReviewDbBatchUpdate.this.changeNotesFactory.createForBatchUpdate(c, !isNew);
            return new ChangeContextImpl(notes, new BatchUpdateReviewDb(db), repo, rw);
        }

        private NoteDbUpdateManager stageNoteDbUpdate(ChangeContextImpl ctx, boolean deleted) throws OrmException, IOException {
            this.logDebug("Staging NoteDb update", new Object[0]);
            NoteDbUpdateManager updateManager = ReviewDbBatchUpdate.this.updateManagerFactory.create(ctx.getProject()).setChangeRepo(ctx.threadLocalRepo, ctx.threadLocalRevWalk, null, new ChainedReceiveCommands(ctx.threadLocalRepo));
            if (ctx.getUser().isIdentifiedUser()) {
                updateManager.setRefLogIdent(ctx.getUser().asIdentifiedUser().newRefLogIdent(ctx.getWhen(), ReviewDbBatchUpdate.this.tz));
            }
            for (ChangeUpdate u : ctx.updates.values()) {
                updateManager.add(u);
            }
            Change c = ctx.getChange();
            if (deleted) {
                updateManager.deleteChange(c.getId());
            }
            try {
                updateManager.stageAndApplyDelta(c);
            }
            catch (NoteDbUpdateManager.MismatchedStateException ex) {
                this.logDebug("Ignoring MismatchedStateException while staging", new Object[0]);
            }
            return updateManager;
        }

        private boolean isNewChange(Change.Id id) {
            return ReviewDbBatchUpdate.this.newChanges.containsKey(id);
        }

        private void logDebug(String msg, Throwable t) {
            if (log.isDebugEnabled()) {
                ReviewDbBatchUpdate.this.logDebug("[" + this.taskId + "]" + msg, t);
            }
        }

        private void logDebug(String msg, Object ... args) {
            if (log.isDebugEnabled()) {
                ReviewDbBatchUpdate.this.logDebug("[" + this.taskId + "]" + msg, args);
            }
        }
    }

    @Singleton
    private static class Metrics {
        final Timer1<Boolean> executeChangeOpsLatency;

        @Inject
        Metrics(MetricMaker metricMaker) {
            this.executeChangeOpsLatency = metricMaker.newTimer("batch_update/execute_change_ops", new Description("BatchUpdate change update latency, excluding reindexing").setCumulative().setUnit("milliseconds"), Field.ofBoolean("success"));
        }
    }

    private class ChangeContextImpl
    extends ContextImpl
    implements ChangeContext {
        private final ChangeNotes notes;
        private final Map<PatchSet.Id, ChangeUpdate> updates;
        private final ReviewDbWrapper dbWrapper;
        private final Repository threadLocalRepo;
        private final RevWalk threadLocalRevWalk;
        private boolean deleted;
        private boolean bumpLastUpdatedOn;

        protected ChangeContextImpl(ChangeNotes notes, ReviewDbWrapper dbWrapper, Repository repo, RevWalk rw) {
            this.bumpLastUpdatedOn = true;
            this.notes = Preconditions.checkNotNull(notes);
            this.dbWrapper = dbWrapper;
            this.threadLocalRepo = repo;
            this.threadLocalRevWalk = rw;
            this.updates = new TreeMap<PatchSet.Id, ChangeUpdate>(Comparator.comparing(PatchSet.Id::get));
        }

        @Override
        public ReviewDb getDb() {
            Preconditions.checkNotNull(this.dbWrapper);
            return this.dbWrapper;
        }

        @Override
        public RevWalk getRevWalk() {
            return this.threadLocalRevWalk;
        }

        @Override
        public ChangeUpdate getUpdate(PatchSet.Id psId) {
            ChangeUpdate u = this.updates.get(psId);
            if (u == null) {
                u = ReviewDbBatchUpdate.this.changeUpdateFactory.create(this.notes, ReviewDbBatchUpdate.this.user, ReviewDbBatchUpdate.this.when);
                if (ReviewDbBatchUpdate.this.newChanges.containsKey(this.notes.getChangeId())) {
                    u.setAllowWriteToNewRef(true);
                }
                u.setPatchSetId(psId);
                this.updates.put(psId, u);
            }
            return u;
        }

        @Override
        public ChangeNotes getNotes() {
            return this.notes;
        }

        @Override
        public void dontBumpLastUpdatedOn() {
            this.bumpLastUpdatedOn = false;
        }

        @Override
        public void deleteChange() {
            this.deleted = true;
        }
    }

    private class RepoContextImpl
    extends ContextImpl
    implements RepoContext {
        private RepoContextImpl() {
        }

        @Override
        public ObjectInserter getInserter() throws IOException {
            return this.getRepoView().getInserterWrapper();
        }

        @Override
        public void addRefUpdate(ReceiveCommand cmd) throws IOException {
            ReviewDbBatchUpdate.this.initRepository();
            ReviewDbBatchUpdate.this.repoView.getCommands().add(cmd);
        }
    }

    class ContextImpl
    implements Context {
        ContextImpl() {
        }

        @Override
        public RepoView getRepoView() throws IOException {
            return ReviewDbBatchUpdate.this.getRepoView();
        }

        @Override
        public RevWalk getRevWalk() throws IOException {
            return this.getRepoView().getRevWalk();
        }

        @Override
        public Project.NameKey getProject() {
            return ReviewDbBatchUpdate.this.project;
        }

        @Override
        public Timestamp getWhen() {
            return ReviewDbBatchUpdate.this.when;
        }

        @Override
        public TimeZone getTimeZone() {
            return ReviewDbBatchUpdate.this.tz;
        }

        @Override
        public ReviewDb getDb() {
            return ReviewDbBatchUpdate.this.db;
        }

        @Override
        public CurrentUser getUser() {
            return ReviewDbBatchUpdate.this.user;
        }

        @Override
        public Order getOrder() {
            return ReviewDbBatchUpdate.this.order;
        }
    }

    static interface AssistedFactory {
        public ReviewDbBatchUpdate create(ReviewDb var1, Project.NameKey var2, CurrentUser var3, Timestamp var4);
    }
}

