/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeFinder;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.permissions.ChangePermission;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ChangeArgumentParser {
    private final CurrentUser currentUser;
    private final ChangesCollection changesCollection;
    private final ChangeFinder changeFinder;
    private final ReviewDb db;
    private final ChangeNotes.Factory changeNotesFactory;
    private final PermissionBackend permissionBackend;

    @Inject
    ChangeArgumentParser(CurrentUser currentUser, ChangesCollection changesCollection, ChangeFinder changeFinder, ReviewDb db, ChangeNotes.Factory changeNotesFactory, PermissionBackend permissionBackend) {
        this.currentUser = currentUser;
        this.changesCollection = changesCollection;
        this.changeFinder = changeFinder;
        this.db = db;
        this.changeNotesFactory = changeNotesFactory;
        this.permissionBackend = permissionBackend;
    }

    public void addChange(String id, Map<Change.Id, ChangeResource> changes) throws BaseCommand.UnloggedFailure, OrmException, PermissionBackendException {
        this.addChange(id, changes, null);
    }

    public void addChange(String id, Map<Change.Id, ChangeResource> changes, ProjectControl projectControl) throws BaseCommand.UnloggedFailure, OrmException, PermissionBackendException {
        this.addChange(id, changes, projectControl, true);
    }

    public void addChange(String id, Map<Change.Id, ChangeResource> changes, ProjectControl projectControl, boolean useIndex) throws BaseCommand.UnloggedFailure, OrmException, PermissionBackendException {
        ChangeResource changeResource;
        boolean canMaintainServer;
        List<ChangeNotes> matched = useIndex ? this.changeFinder.find(id) : this.changeFromNotesFactory(id);
        ArrayList<ChangeNotes> toAdd = new ArrayList<ChangeNotes>(changes.size());
        try {
            this.permissionBackend.user(this.currentUser).check(GlobalPermission.MAINTAIN_SERVER);
            canMaintainServer = true;
        }
        catch (AuthException | PermissionBackendException e) {
            canMaintainServer = false;
        }
        for (ChangeNotes notes : matched) {
            if (changes.containsKey(notes.getChangeId()) || !this.inProject(projectControl, notes.getProjectName()) || !canMaintainServer && !((PermissionBackend.ForChange)this.permissionBackend.user(this.currentUser).change(notes).database(this.db)).test(ChangePermission.READ)) continue;
            toAdd.add(notes);
        }
        if (toAdd.isEmpty()) {
            throw new BaseCommand.UnloggedFailure(1, "\"" + id + "\" no such change");
        }
        if (toAdd.size() > 1) {
            throw new BaseCommand.UnloggedFailure(1, "\"" + id + "\" matches multiple changes");
        }
        Change.Id cId = ((ChangeNotes)toAdd.get(0)).getChangeId();
        try {
            changeResource = this.changesCollection.parse(cId);
        }
        catch (ResourceNotFoundException e) {
            throw new BaseCommand.UnloggedFailure(1, "\"" + id + "\" no such change");
        }
        changes.put(cId, changeResource);
    }

    private List<ChangeNotes> changeFromNotesFactory(String id) throws OrmException, BaseCommand.UnloggedFailure {
        return this.changeNotesFactory.create(this.db, this.parseId(id));
    }

    private List<Change.Id> parseId(String id) throws BaseCommand.UnloggedFailure {
        try {
            return Arrays.asList(new Change.Id(Integer.parseInt(id)));
        }
        catch (NumberFormatException e) {
            throw new BaseCommand.UnloggedFailure(2, "Invalid change ID " + id, e);
        }
    }

    private boolean inProject(ProjectControl projectControl, Project.NameKey project) {
        if (projectControl != null) {
            return projectControl.getProject().getNameKey().equals(project);
        }
        return true;
    }
}

