/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountLimits;
import com.google.gerrit.server.git.QueueProvider;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.ScheduledThreadPoolExecutor;

class CommandExecutorProvider
implements Provider<ScheduledThreadPoolExecutor> {
    private final AccountLimits.Factory limitsFactory;
    private final QueueProvider queues;
    private final CurrentUser user;

    @Inject
    CommandExecutorProvider(AccountLimits.Factory limitsFactory, QueueProvider queues, CurrentUser user) {
        this.limitsFactory = limitsFactory;
        this.queues = queues;
        this.user = user;
    }

    @Override
    public ScheduledThreadPoolExecutor get() {
        return this.queues.getQueue(this.limitsFactory.create(this.user).getQueueType());
    }
}

