/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.annotations.RequiresCapability;
import com.google.gerrit.server.index.ReindexerAlreadyRunningException;
import com.google.gerrit.server.index.VersionManager;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import org.kohsuke.args4j.Argument;

@RequiresCapability(value="administrateServer")
@CommandMetaData(name="activate", description="Activate the latest index version available")
public class IndexActivateCommand
extends SshCommand {
    @Argument(index=0, required=true, metaVar="INDEX", usage="index name to activate")
    private String name;
    @Inject
    private VersionManager versionManager;

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        try {
            if (this.versionManager.isKnownIndex(this.name)) {
                if (this.versionManager.activateLatestIndex(this.name)) {
                    this.stdout.println("Activated latest index version");
                } else {
                    this.stdout.println("Not activating index, already using latest version");
                }
            } else {
                this.stderr.println(String.format("Cannot activate index %s: unknown", this.name));
            }
        }
        catch (ReindexerAlreadyRunningException e) {
            throw this.die("Failed to activate latest index: " + e.getMessage());
        }
    }
}

