/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.AutoValue_TypeInfo;
import org.objectweb.asm.Type;

abstract class TypeInfo {
    TypeInfo() {
    }

    static TypeInfo create(Class<?> clazz) {
        Type type = Type.getType(clazz);
        return new AutoValue_TypeInfo(clazz.getName(), clazz.getSimpleName(), type.getInternalName(), type);
    }

    static TypeInfo create(String className) {
        Type type = Type.getObjectType(className.replace('.', '/'));
        String packageLessName = className.substring(className.lastIndexOf(46) + 1);
        String simpleName = packageLessName.substring(packageLessName.lastIndexOf(36) + 1);
        return new AutoValue_TypeInfo(className, simpleName, type.getInternalName(), type);
    }

    abstract String className();

    abstract String simpleName();

    abstract String internalName();

    abstract Type type();

    final TypeInfo innerClass(String simpleName) {
        Preconditions.checkArgument(simpleName.indexOf(36) == -1, "Simple names shouldn't contain '$': %s", (Object)simpleName);
        String className = this.className() + '$' + simpleName;
        String internalName = this.internalName() + '$' + simpleName;
        Type type = Type.getObjectType(internalName);
        return new AutoValue_TypeInfo(className, simpleName, internalName, type);
    }
}

