/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.AssertStrictAutoescapingVisitor;
import com.google.template.soy.passes.CheckDelegatesVisitor;
import com.google.template.soy.passes.CheckFunctionCallsPass;
import com.google.template.soy.passes.CheckGlobalsPass;
import com.google.template.soy.passes.CheckInvalidParamsVisitor;
import com.google.template.soy.passes.CheckProtoInitCallsPass;
import com.google.template.soy.passes.CheckTemplateCallsPass;
import com.google.template.soy.passes.CheckTemplateParamsVisitor;
import com.google.template.soy.passes.CheckTemplateVisibility;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.DesugarHtmlNodesPass;
import com.google.template.soy.passes.HtmlRewritePass;
import com.google.template.soy.passes.InferRequiredSyntaxVersion;
import com.google.template.soy.passes.ReportSyntaxVersionErrors;
import com.google.template.soy.passes.ResolveExpressionTypesVisitor;
import com.google.template.soy.passes.ResolveFunctionsVisitor;
import com.google.template.soy.passes.ResolveNamesVisitor;
import com.google.template.soy.passes.ResolvePackageRelativeCssNamesVisitor;
import com.google.template.soy.passes.RewriteFunctionsPass;
import com.google.template.soy.passes.RewriteGenderMsgsVisitor;
import com.google.template.soy.passes.RewriteGlobalsPass;
import com.google.template.soy.passes.RewriteRemaindersVisitor;
import com.google.template.soy.passes.SetFullCalleeNamesVisitor;
import com.google.template.soy.passes.StrictDepsVisitor;
import com.google.template.soy.passes.StrictHtmlValidationPass;
import com.google.template.soy.passes.VerifyPhnameAttrOnlyOnPlaceholdersVisitor;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.Objects;

public final class PassManager {
    private final ImmutableList<CompilerFilePass> singleFilePasses;
    private final ImmutableList<CompilerFileSetPass> fileSetPasses;
    private final SoyTypeRegistry registry;
    private final ImmutableMap<String, ? extends SoyFunction> soyFunctionMap;
    private final ErrorReporter errorReporter;
    private final SyntaxVersion declaredSyntaxVersion;
    private final SoyGeneralOptions options;
    private final boolean allowUnknownGlobals;
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_GLOBAL = SoyErrorKind.of("Alias ''{0}'' conflicts with a global of the same name.");
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_GLOBAL_PREFIX = SoyErrorKind.of("Alias ''{0}'' conflicts with namespace for global ''{1}''.");

    private PassManager(Builder builder) {
        this.registry = Preconditions.checkNotNull(builder.registry);
        this.soyFunctionMap = Preconditions.checkNotNull(builder.soyFunctionMap);
        this.errorReporter = Preconditions.checkNotNull(builder.errorReporter);
        this.declaredSyntaxVersion = Preconditions.checkNotNull(builder.declaredSyntaxVersion);
        this.options = Preconditions.checkNotNull(builder.opts);
        this.allowUnknownGlobals = builder.allowUnknownGlobals;
        boolean enabledStrictHtml = this.options.getExperimentalFeatures().contains("stricthtml");
        ImmutableCollection.ArrayBasedBuilder singleFilePassesBuilder = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(new RewriteGendersPass())).add(new RewriteRemaindersPass())).add(new HtmlRewritePass(this.options.getExperimentalFeatures(), this.errorReporter))).add(new StrictHtmlValidationPass(this.options.getExperimentalFeatures(), this.errorReporter))).add(new RewriteGlobalsPass(this.registry, this.options.getCompileTimeGlobals(), this.errorReporter))).add(new RewriteFunctionsPass(this.registry))).add(new SetFullCalleeNamesPass())).add(new ResolveNamesPass())).add(new ResolveFunctionsPass())).add(new ResolveExpressionTypesPass())).add(new ResolvePackageRelativeCssNamesPass())).add(new VerifyPhnameAttrOnlyOnPlaceholdersPass());
        if (!this.allowUnknownGlobals) {
            ((ImmutableList.Builder)singleFilePassesBuilder).add(new CheckGlobalsPass(this.errorReporter));
        }
        ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)singleFilePassesBuilder).add(new CheckInvalidParamsPass())).add(new ValidateAliasesPass())).add(new CheckSyntaxVersionPass())).add(new CheckProtoInitCallsPass(this.errorReporter))).add(new CheckFunctionCallsPass(builder.allowUnknownFunctions, this.declaredSyntaxVersion, this.errorReporter));
        if (this.options.isStrictAutoescapingRequired()) {
            ((ImmutableList.Builder)singleFilePassesBuilder).add(new EnforceStrictAutoescapingPass());
        }
        this.singleFilePasses = ((ImmutableList.Builder)singleFilePassesBuilder).build();
        ImmutableCollection.ArrayBasedBuilder fileSetPassBuilder = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(new CheckTemplateParamsPass())).add(new CheckTemplateCallsPass(enabledStrictHtml, this.errorReporter))).add(new CheckVisibilityPass())).add(new CheckDelegatesPass());
        if (Objects.equals(this.options.allowExternalCalls(), Boolean.FALSE)) {
            ((ImmutableList.Builder)fileSetPassBuilder).add(new StrictDepsPass());
        }
        ((ImmutableList.Builder)fileSetPassBuilder).add(new DesugarHtmlNodesPass());
        this.fileSetPasses = ((ImmutableList.Builder)fileSetPassBuilder).build();
    }

    public void runSingleFilePasses(SoyFileNode file, IdGenerator nodeIdGen) {
        for (CompilerFilePass pass : this.singleFilePasses) {
            pass.run(file, nodeIdGen);
        }
    }

    public void runWholeFilesetPasses(TemplateRegistry registry, SoyFileSetNode soyTree) {
        for (CompilerFileSetPass pass : this.fileSetPasses) {
            pass.run(soyTree, registry);
        }
    }

    private final class ValidateAliasesPass
    extends CompilerFilePass {
        private ValidateAliasesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            for (AliasDeclaration alias : file.getAliasDeclarations()) {
                if (PassManager.this.options.getCompileTimeGlobals().containsKey(alias.getAlias())) {
                    PassManager.this.errorReporter.report(alias.getLocation(), ALIAS_CONFLICTS_WITH_GLOBAL, alias.getAlias());
                }
                for (String global : PassManager.this.options.getCompileTimeGlobals().keySet()) {
                    if (!global.startsWith(alias.getAlias() + ".")) continue;
                    PassManager.this.errorReporter.report(alias.getLocation(), ALIAS_CONFLICTS_WITH_GLOBAL_PREFIX, alias.getAlias(), global);
                }
            }
        }
    }

    private final class StrictDepsPass
    extends CompilerFileSetPass {
        private StrictDepsPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new StrictDepsVisitor(registry, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class CheckVisibilityPass
    extends CompilerFileSetPass {
        private CheckVisibilityPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new CheckTemplateVisibility(registry, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class CheckDelegatesPass
    extends CompilerFileSetPass {
        private final boolean enabledStrictHtml;

        private CheckDelegatesPass() {
            this.enabledStrictHtml = PassManager.this.options.getExperimentalFeatures().contains("stricthtml");
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new CheckDelegatesVisitor(registry, this.enabledStrictHtml, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class CheckTemplateParamsPass
    extends CompilerFileSetPass {
        private CheckTemplateParamsPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new CheckTemplateParamsVisitor(registry, PassManager.this.declaredSyntaxVersion, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class EnforceStrictAutoescapingPass
    extends CompilerFilePass {
        final AssertStrictAutoescapingVisitor visitor;

        private EnforceStrictAutoescapingPass() {
            this.visitor = new AssertStrictAutoescapingVisitor(PassManager.this.errorReporter);
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            this.visitor.exec(file);
        }
    }

    private final class CheckInvalidParamsPass
    extends CompilerFilePass {
        private CheckInvalidParamsPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new CheckInvalidParamsVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class VerifyPhnameAttrOnlyOnPlaceholdersPass
    extends CompilerFilePass {
        private VerifyPhnameAttrOnlyOnPlaceholdersPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new VerifyPhnameAttrOnlyOnPlaceholdersVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class ResolvePackageRelativeCssNamesPass
    extends CompilerFilePass {
        private ResolvePackageRelativeCssNamesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new ResolvePackageRelativeCssNamesVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class ResolveExpressionTypesPass
    extends CompilerFilePass {
        private ResolveExpressionTypesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new ResolveExpressionTypesVisitor(PassManager.this.registry, PassManager.this.declaredSyntaxVersion, PassManager.this.errorReporter).exec(file);
        }
    }

    private final class ResolveFunctionsPass
    extends CompilerFilePass {
        private ResolveFunctionsPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            SoyTreeUtils.execOnAllV2Exprs(file, new ResolveFunctionsVisitor(PassManager.this.soyFunctionMap));
        }
    }

    private final class ResolveNamesPass
    extends CompilerFilePass {
        private ResolveNamesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new ResolveNamesVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class SetFullCalleeNamesPass
    extends CompilerFilePass {
        private SetFullCalleeNamesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new SetFullCalleeNamesVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class RewriteRemaindersPass
    extends CompilerFilePass {
        private RewriteRemaindersPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new RewriteRemaindersVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class RewriteGendersPass
    extends CompilerFilePass {
        private RewriteGendersPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new RewriteGenderMsgsVisitor(nodeIdGen, PassManager.this.errorReporter).exec(file);
        }
    }

    private final class CheckSyntaxVersionPass
    extends CompilerFilePass {
        final ReportSyntaxVersionErrors reportDeclaredVersionErrors;

        private CheckSyntaxVersionPass() {
            this.reportDeclaredVersionErrors = new ReportSyntaxVersionErrors(PassManager.this.declaredSyntaxVersion, true, PassManager.this.errorReporter);
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            ErrorReporter.Checkpoint checkpoint = PassManager.this.errorReporter.checkpoint();
            this.reportDeclaredVersionErrors.report(file);
            if (!PassManager.this.errorReporter.errorsSince(checkpoint)) {
                SyntaxVersion inferredSyntaxVersion = InferRequiredSyntaxVersion.infer(file);
                if (inferredSyntaxVersion.num > ((PassManager)PassManager.this).declaredSyntaxVersion.num) {
                    new ReportSyntaxVersionErrors(inferredSyntaxVersion, false, PassManager.this.errorReporter).report(file);
                }
            }
        }
    }

    public static final class Builder {
        private SoyTypeRegistry registry;
        private ImmutableMap<String, ? extends SoyFunction> soyFunctionMap;
        private ErrorReporter errorReporter;
        private SyntaxVersion declaredSyntaxVersion;
        private SoyGeneralOptions opts;
        private boolean allowUnknownGlobals;
        private boolean allowUnknownFunctions;

        public Builder setErrorReporter(ErrorReporter errorReporter) {
            this.errorReporter = Preconditions.checkNotNull(errorReporter);
            return this;
        }

        public Builder setSoyFunctionMap(ImmutableMap<String, ? extends SoyFunction> functionMap) {
            this.soyFunctionMap = Preconditions.checkNotNull(functionMap);
            return this;
        }

        public Builder setTypeRegistry(SoyTypeRegistry registry) {
            this.registry = Preconditions.checkNotNull(registry);
            return this;
        }

        public Builder setDeclaredSyntaxVersion(SyntaxVersion declaredSyntaxVersion) {
            this.declaredSyntaxVersion = Preconditions.checkNotNull(declaredSyntaxVersion);
            return this;
        }

        public Builder setGeneralOptions(SoyGeneralOptions opts) {
            this.opts = opts;
            return this;
        }

        public Builder allowUnknownGlobals() {
            this.allowUnknownGlobals = true;
            return this;
        }

        public Builder allowUnknownFunctions() {
            this.allowUnknownFunctions = true;
            return this;
        }

        public PassManager build() {
            return new PassManager(this);
        }
    }
}

