/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.GenPyCallExprVisitor;
import com.google.template.soy.pysrc.internal.GenPyCodeVisitor;
import com.google.template.soy.pysrc.internal.GenPyExprsVisitor;
import com.google.template.soy.pysrc.internal.IsCalleeInFileVisitor;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.pysrc.internal.MsgFuncGenerator;
import com.google.template.soy.pysrc.internal.PyApiCallScopeBindingAnnotations;
import com.google.template.soy.pysrc.internal.PySrcMain;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.shared.internal.ApiCallScope;
import com.google.template.soy.shared.internal.FunctionAdapters;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.util.Set;
import javax.inject.Singleton;

public final class PySrcModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.bind(PySrcMain.class);
        this.bind(GenPyCodeVisitor.class);
        this.bind(GenPyCallExprVisitor.class);
        this.bind(IsComputableAsPyExprVisitor.class);
        this.bind(IsCalleeInFileVisitor.class);
        this.install(new FactoryModuleBuilder().build(GenPyExprsVisitor.GenPyExprsVisitorFactory.class));
        this.install(new FactoryModuleBuilder().build(MsgFuncGenerator.MsgFuncGeneratorFactory.class));
        this.bind(SoyPySrcOptions.class).toProvider(GuiceSimpleScope.getUnscopedProvider()).in(ApiCallScope.class);
        this.bind(new Key<ImmutableMap<String, String>>(PyApiCallScopeBindingAnnotations.PyCurrentManifest.class){}).toProvider(GuiceSimpleScope.getUnscopedProvider()).in(ApiCallScope.class);
    }

    @Provides
    @Singleton
    ImmutableMap<String, SoyPySrcPrintDirective> provideSoyPySrcDirectivesMap(Set<SoyPrintDirective> soyDirectivesSet) {
        return FunctionAdapters.buildSpecificSoyDirectivesMap(soyDirectivesSet, SoyPySrcPrintDirective.class);
    }
}

