/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Ascii;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import javax.annotation.Nullable;

public final class TagName {
    private static final ImmutableSet<String> VOID_TAG_NAMES = ImmutableSet.of("area", "base", "br", "col", "command", "embed", new String[]{"hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"});
    private static final ImmutableSet<String> OPTIONAL_TAG_NAMES = ImmutableSet.of("body", "colgroup", "dd", "dt", "head", "html", new String[]{"li", "optgroup", "option", "p", "rb", "rp", "rt", "rtc", "tbody", "td", "tfoot", "th", "thead", "tr"});
    private final SoyNode.StandaloneNode node;
    @Nullable
    private final String nameAsLowerCase;
    @Nullable
    private final RcDataTagName rcDataTagName;

    public TagName(RawTextNode node) {
        this.node = Preconditions.checkNotNull(node);
        switch (this.nameAsLowerCase = Ascii.toLowerCase(node.getRawText())) {
            case "script": {
                this.rcDataTagName = RcDataTagName.SCRIPT;
                break;
            }
            case "style": {
                this.rcDataTagName = RcDataTagName.STYLE;
                break;
            }
            case "textarea": {
                this.rcDataTagName = RcDataTagName.TEXTAREA;
                break;
            }
            case "title": {
                this.rcDataTagName = RcDataTagName.TITLE;
                break;
            }
            default: {
                this.rcDataTagName = null;
            }
        }
    }

    public TagName(PrintNode node) {
        this.node = Preconditions.checkNotNull(node);
        this.nameAsLowerCase = null;
        this.rcDataTagName = null;
    }

    public boolean isStatic() {
        return this.node instanceof RawTextNode;
    }

    public boolean isDefinitelyVoid() {
        return VOID_TAG_NAMES.contains(this.nameAsLowerCase);
    }

    public boolean isDefinitelyOptional() {
        return OPTIONAL_TAG_NAMES.contains(this.nameAsLowerCase);
    }

    public boolean isForeignContent() {
        return "svg".equals(this.nameAsLowerCase);
    }

    @Nullable
    public RcDataTagName getRcDataTagName() {
        return this.rcDataTagName;
    }

    public RawTextNode getStaticTagName() {
        Preconditions.checkState(this.isStatic());
        return (RawTextNode)this.node;
    }

    public Optional<String> getStaticTagNameAsLowerCase() {
        return Optional.fromNullable(this.nameAsLowerCase);
    }

    public SoyNode.StandaloneNode getNode() {
        return this.node;
    }

    public PrintNode getDynamicTagName() {
        Preconditions.checkState(!this.isStatic());
        return (PrintNode)this.node;
    }

    public SourceLocation getTagLocation() {
        return this.node.getSourceLocation();
    }

    public boolean equals(Object other) {
        if (other instanceof TagName) {
            TagName tag = (TagName)other;
            if (this.isStatic() != tag.isStatic()) {
                return false;
            }
            if (this.isStatic()) {
                return this.nameAsLowerCase.equals(tag.nameAsLowerCase);
            }
            return this.comparePrintNode((PrintNode)this.node, (PrintNode)tag.node);
        }
        return false;
    }

    private boolean comparePrintNode(PrintNode firstNode, PrintNode secondNode) {
        ExprEquivalence exprEquivalence = ExprEquivalence.get();
        if (!exprEquivalence.equivalent(firstNode.getExpr(), secondNode.getExpr())) {
            return false;
        }
        List firstNodeDirectives = firstNode.getChildren();
        List secondNodeDirectives = secondNode.getChildren();
        if (firstNodeDirectives.size() != secondNodeDirectives.size()) {
            return false;
        }
        for (int i = 0; i < firstNodeDirectives.size(); ++i) {
            if (((PrintDirectiveNode)firstNodeDirectives.get(i)).getName().equals(((PrintDirectiveNode)secondNodeDirectives.get(i)).getName())) {
                return false;
            }
            ImmutableList<ExprRootNode> one = ((PrintDirectiveNode)firstNodeDirectives.get(i)).getExprList();
            ImmutableList<ExprRootNode> two = ((PrintDirectiveNode)secondNodeDirectives.get(i)).getExprList();
            if (exprEquivalence.pairwise().equivalent(one, two)) continue;
            return false;
        }
        return true;
    }

    private static int hashPrintNode(PrintNode node) {
        ExprEquivalence exprEquivalence = ExprEquivalence.get();
        int hc = exprEquivalence.hash(node.getExpr());
        for (PrintDirectiveNode child : node.getChildren()) {
            ImmutableList<ExprRootNode> list = child.getExprList();
            hc = 31 * hc + child.getName().hashCode();
            hc = 31 * hc + exprEquivalence.pairwise().hash(list);
        }
        return hc;
    }

    public int hashCode() {
        return this.isStatic() ? this.nameAsLowerCase.hashCode() : TagName.hashPrintNode((PrintNode)this.node);
    }

    public String toString() {
        return this.node.toSourceString();
    }

    public static enum RcDataTagName {
        SCRIPT,
        STYLE,
        TITLE,
        TEXTAREA;


        public String toString() {
            return Ascii.toLowerCase(this.name());
        }
    }
}

