/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.exceptions;

import com.googlecode.prolog_cafe.exceptions.BuiltinException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;

public class ExistenceException
extends BuiltinException {
    private static final long serialVersionUID = 1L;
    public static final SymbolTerm EXISTENCE_ERROR = SymbolTerm.intern("existence_error", 5);
    public String objType;
    public Term culprit;
    public String msg;

    public ExistenceException(String string, Term term, String string2) {
        this.objType = string;
        this.culprit = term;
        this.msg = string2;
    }

    public ExistenceException(Operation operation, int n, String string, Term term, String string2) {
        this.goal = operation;
        this.argNo = n;
        this.objType = string;
        this.culprit = term;
        this.msg = string2;
    }

    @Override
    public Term getMessageTerm() {
        Term[] termArray = new Term[]{new JavaObjectTerm(this.goal), new IntegerTerm(this.argNo), SymbolTerm.create(this.objType), this.culprit, SymbolTerm.create(this.msg)};
        return new StructureTerm(EXISTENCE_ERROR, termArray);
    }

    @Override
    public String toString() {
        String string = "{EXISTENCE ERROR:";
        if (this.argNo > 0) {
            string = string + " " + this.goal.toString() + " - arg " + this.argNo + ":";
        }
        string = string + this.objType + " " + this.culprit.toString() + " does not exist";
        string = string + "}";
        return string;
    }
}

