/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.channels.Channel;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.ChannelHolder;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.channel.WindowClosedException;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.slf4j.Logger;

public class ChannelOutputStream
extends OutputStream
implements Channel,
ChannelHolder {
    public static final String WAIT_FOR_SPACE_TIMEOUT = "channel-output-wait-for-space-timeout";
    public static final long DEFAULT_WAIT_FOR_SPACE_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    private final AbstractChannel channelInstance;
    private final Window remoteWindow;
    private final long maxWaitTimeout;
    private final Logger log;
    private final byte cmd;
    private final boolean eofOnClose;
    private final byte[] b = new byte[1];
    private final AtomicBoolean closedState = new AtomicBoolean(false);
    private Buffer buffer;
    private int bufferLength;
    private int lastSize;
    private boolean noDelay;

    public ChannelOutputStream(AbstractChannel channel, Window remoteWindow, Logger log, byte cmd, boolean eofOnClose) {
        this(channel, remoteWindow, channel.getLongProperty(WAIT_FOR_SPACE_TIMEOUT, DEFAULT_WAIT_FOR_SPACE_TIMEOUT), log, cmd, eofOnClose);
    }

    public ChannelOutputStream(AbstractChannel channel, Window remoteWindow, long maxWaitTimeout, Logger log, byte cmd, boolean eofOnClose) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel");
        this.remoteWindow = Objects.requireNonNull(remoteWindow, "No remote window");
        ValidateUtils.checkTrue(maxWaitTimeout > 0L, "Non-positive max. wait time: %d", maxWaitTimeout);
        this.maxWaitTimeout = maxWaitTimeout;
        this.log = Objects.requireNonNull(log, "No logger");
        this.cmd = cmd;
        this.eofOnClose = eofOnClose;
        this.newBuffer(0);
    }

    @Override
    public AbstractChannel getChannel() {
        return this.channelInstance;
    }

    public boolean isEofOnClose() {
        return this.eofOnClose;
    }

    public void setNoDelay(boolean noDelay) {
        this.noDelay = noDelay;
    }

    public boolean isNoDelay() {
        return this.noDelay;
    }

    @Override
    public boolean isOpen() {
        return !this.closedState.get();
    }

    @Override
    public synchronized void write(int w) throws IOException {
        this.b[0] = (byte)w;
        this.write(this.b, 0, 1);
    }

    @Override
    public synchronized void write(byte[] buf, int s, int l) throws IOException {
        if (!this.isOpen()) {
            throw new SshException("write(" + this + ") len=" + l + " - channel already closed");
        }
        AbstractChannel channel = this.getChannel();
        Session session = channel.getSession();
        while (l > 0) {
            long l2 = Math.min((long)l, Math.min(this.remoteWindow.getSize() + (long)this.lastSize, this.remoteWindow.getPacketSize()) - (long)this.bufferLength);
            if (l2 <= 0L) {
                if (this.bufferLength > 0) {
                    this.flush();
                } else {
                    session.resetIdleTimeout();
                    try {
                        long available = this.remoteWindow.waitForSpace(this.maxWaitTimeout);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("write({}) len={} - available={}", this, l, available);
                        }
                    }
                    catch (IOException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("write({}) failed ({}) to wait for space of len={}: {}", this, e.getClass().getSimpleName(), l, e.getMessage());
                        }
                        if (e instanceof WindowClosedException && !this.closedState.getAndSet(true) && this.log.isDebugEnabled()) {
                            this.log.debug("write({})[len={}] closing due to window closed", (Object)this, (Object)l);
                        }
                        throw e;
                    }
                    catch (InterruptedException e) {
                        throw (IOException)new InterruptedIOException("Interrupted while waiting for remote space on write len=" + l + " to " + this).initCause(e);
                    }
                }
                session.resetIdleTimeout();
                continue;
            }
            ValidateUtils.checkTrue(l2 <= Integer.MAX_VALUE, "Accumulated bytes length exceeds int boundary: %d", l2);
            this.buffer.putRawBytes(buf, s, (int)l2);
            this.bufferLength = (int)((long)this.bufferLength + l2);
            s = (int)((long)s + l2);
            l = (int)((long)l - l2);
        }
        if (this.isNoDelay()) {
            this.flush();
        } else {
            session.resetIdleTimeout();
        }
    }

    @Override
    public synchronized void flush() throws IOException {
        if (!this.isOpen()) {
            throw new SshException("flush(" + this + ") length=" + this.bufferLength + " - stream is already closed");
        }
        try {
            AbstractChannel channel = this.getChannel();
            Session session = channel.getSession();
            while (this.bufferLength > 0) {
                long available;
                session.resetIdleTimeout();
                Buffer buf = this.buffer;
                long total = this.bufferLength;
                try {
                    available = this.remoteWindow.waitForSpace(this.maxWaitTimeout);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("flush({}) len={}, available={}", this, total, available);
                    }
                }
                catch (IOException e) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("flush({}) failed ({}) to wait for space of len={}: {}", this, e.getClass().getSimpleName(), total, e.getMessage());
                    }
                    throw e;
                }
                long lenToSend = Math.min(available, total);
                long length = Math.min(lenToSend, this.remoteWindow.getPacketSize());
                if (length > Integer.MAX_VALUE) {
                    throw new StreamCorruptedException("Accumulated " + SshConstants.getCommandMessageName(this.cmd) + " command bytes size (" + length + ") exceeds int boundaries");
                }
                int pos = buf.wpos();
                buf.wpos(this.cmd == 95 ? 14 : 10);
                buf.putInt(length);
                buf.wpos(buf.wpos() + (int)length);
                if (total == length) {
                    this.newBuffer((int)length);
                } else {
                    long leftover = total - length;
                    this.newBuffer((int)Math.max(leftover, length));
                    this.buffer.putRawBytes(buf.array(), pos - (int)leftover, (int)leftover);
                    this.bufferLength = (int)leftover;
                }
                this.lastSize = (int)length;
                session.resetIdleTimeout();
                this.remoteWindow.waitAndConsume(length, this.maxWaitTimeout);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("flush({}) send {} len={}", channel, SshConstants.getCommandMessageName(this.cmd), length);
                }
                channel.writePacket(buf);
            }
        }
        catch (WindowClosedException e) {
            if (!this.closedState.getAndSet(true) && this.log.isDebugEnabled()) {
                this.log.debug("flush({}) closing due to window closed", (Object)this);
            }
            throw e;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof InterruptedException) {
                throw (IOException)new InterruptedIOException("Interrupted while waiting for remote space flush len=" + this.bufferLength + " to " + this).initCause(e);
            }
            throw new SshException(e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.isOpen()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("close({}) closing", (Object)this);
            }
            try {
                this.flush();
                if (this.isEofOnClose()) {
                    AbstractChannel channel = this.getChannel();
                    channel.sendEof();
                }
            }
            finally {
                this.closedState.set(true);
            }
        }
    }

    protected void newBuffer(int size) {
        AbstractChannel channel = this.getChannel();
        Session session = channel.getSession();
        this.buffer = session.createBuffer(this.cmd, size <= 0 ? 12 : 12 + size);
        this.buffer.putInt(channel.getRecipient());
        if (this.cmd == 95) {
            this.buffer.putInt(1L);
        }
        this.buffer.putInt(0L);
        this.bufferLength = 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getChannel() + "] " + SshConstants.getCommandMessageName(this.cmd & 0xFF);
    }
}

