/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.io.nio2;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2CompletionHandler;
import org.apache.sshd.common.io.nio2.Nio2DefaultIoWriteFuture;
import org.apache.sshd.common.io.nio2.Nio2Service;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;

public class Nio2Session
extends AbstractCloseable
implements IoSession {
    public static final int DEFAULT_READBUF_SIZE = 32768;
    private static final AtomicLong SESSION_ID_GENERATOR = new AtomicLong(100L);
    private final long id = SESSION_ID_GENERATOR.incrementAndGet();
    private final Nio2Service service;
    private final IoHandler ioHandler;
    private final AsynchronousSocketChannel socketChannel;
    private final Map<Object, Object> attributes = new HashMap<Object, Object>();
    private final SocketAddress localAddress;
    private final SocketAddress remoteAddress;
    private final FactoryManager manager;
    private final Queue<Nio2DefaultIoWriteFuture> writes = new LinkedTransferQueue<Nio2DefaultIoWriteFuture>();
    private final AtomicReference<Nio2DefaultIoWriteFuture> currentWrite = new AtomicReference();

    public Nio2Session(Nio2Service service, FactoryManager manager, IoHandler handler, AsynchronousSocketChannel socket) throws IOException {
        this.service = Objects.requireNonNull(service, "No service instance");
        this.manager = Objects.requireNonNull(manager, "No factory manager");
        this.ioHandler = Objects.requireNonNull(handler, "No IoHandler");
        this.socketChannel = Objects.requireNonNull(socket, "No socket channel");
        this.localAddress = socket.getLocalAddress();
        this.remoteAddress = socket.getRemoteAddress();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating IoSession on {} from {}", (Object)this.localAddress, (Object)this.remoteAddress);
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public AsynchronousSocketChannel getSocket() {
        return this.socketChannel;
    }

    public IoHandler getIoHandler() {
        return this.ioHandler;
    }

    public void suspend() {
        block5: {
            AsynchronousSocketChannel socket;
            block4: {
                socket = this.getSocket();
                try {
                    socket.shutdownInput();
                }
                catch (IOException e) {
                    if (!this.log.isDebugEnabled()) break block4;
                    this.log.debug("suspend({}) failed {{}) to shutdown input: {}", this, e.getClass().getSimpleName(), e.getMessage());
                }
            }
            try {
                socket.shutdownOutput();
            }
            catch (IOException e) {
                if (!this.log.isDebugEnabled()) break block5;
                this.log.debug("suspend({}) failed {{}) to shutdown output: {}", this, e.getClass().getSimpleName(), e.getMessage());
            }
        }
    }

    @Override
    public IoWriteFuture write(Buffer buffer) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Writing {} bytes", (Object)buffer.available());
        }
        ByteBuffer buf = ByteBuffer.wrap(buffer.array(), buffer.rpos(), buffer.available());
        Nio2DefaultIoWriteFuture future = new Nio2DefaultIoWriteFuture(null, buf);
        if (this.isClosing()) {
            ClosedChannelException exc = new ClosedChannelException();
            future.setException(exc);
            this.exceptionCaught(exc);
            return future;
        }
        this.writes.add(future);
        this.startWriting();
        return future;
    }

    protected void exceptionCaught(Throwable exc) {
        if (!this.closeFuture.isClosed()) {
            AsynchronousSocketChannel socket = this.getSocket();
            if (this.isClosing() || !socket.isOpen()) {
                this.close(true);
            } else {
                IoHandler handler = this.getIoHandler();
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("exceptionCaught({}) caught {}[{}] - calling handler", this, exc.getClass().getSimpleName(), exc.getMessage());
                    }
                    handler.exceptionCaught(this, exc);
                }
                catch (Throwable e) {
                    Throwable t = GenericUtils.peelException(e);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("exceptionCaught({}) Exception handler threw {}, closing the session: {}", this, t.getClass().getSimpleName(), t.getMessage());
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("exceptionCaught(" + this + ") exception handler failure details", t);
                    }
                    this.close(true);
                }
            }
        }
    }

    @Override
    protected CloseFuture doCloseGracefully() {
        return this.builder().when(this.writes).run(() -> {
            try {
                AsynchronousSocketChannel socket = this.getSocket();
                socket.shutdownOutput();
            }
            catch (IOException e) {
                this.log.info("doCloseGracefully({}) {} while shutting down output: {}", this, e.getClass().getSimpleName(), e.getMessage());
            }
        }).build().close(false);
    }

    @Override
    protected void doCloseImmediately() {
        block6: {
            Nio2DefaultIoWriteFuture future;
            while ((future = this.writes.poll()) != null) {
                future.setException(new ClosedChannelException());
            }
            AsynchronousSocketChannel socket = this.getSocket();
            try {
                socket.close();
            }
            catch (IOException e) {
                this.log.info("doCloseImmediately(" + this + ") exception caught while closing socket", e);
            }
            this.service.sessionClosed(this);
            super.doCloseImmediately();
            IoHandler handler = this.getIoHandler();
            try {
                handler.sessionClosed(this);
            }
            catch (Throwable e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doCloseImmediately({}) {} while calling IoHandler#sessionClosed: {}", this, e.getClass().getSimpleName(), e.getMessage());
                }
                if (!this.log.isTraceEnabled()) break block6;
                this.log.trace("doCloseImmediately(" + this + ") IoHandler#sessionClosed failure details", e);
            }
        }
    }

    @Override
    public Nio2Service getService() {
        return this.service;
    }

    public void startReading() {
        this.startReading(this.manager.getIntProperty("nio2-read-buf-size", 32768));
    }

    public void startReading(int bufSize) {
        this.startReading(new byte[bufSize]);
    }

    public void startReading(byte[] buf) {
        this.startReading(buf, 0, buf.length);
    }

    public void startReading(byte[] buf, int offset, int len) {
        this.startReading(ByteBuffer.wrap(buf, offset, len));
    }

    public void startReading(ByteBuffer buffer) {
        this.doReadCycle(buffer, Readable.readable(buffer));
    }

    protected void doReadCycle(ByteBuffer buffer, Readable bufReader) {
        Nio2CompletionHandler<Integer, Object> completion = Objects.requireNonNull(this.createReadCycleCompletionHandler(buffer, bufReader), "No completion handler created");
        this.doReadCycle(buffer, completion);
    }

    protected Nio2CompletionHandler<Integer, Object> createReadCycleCompletionHandler(final ByteBuffer buffer, final Readable bufReader) {
        return new Nio2CompletionHandler<Integer, Object>(){

            @Override
            protected void onCompleted(Integer result, Object attachment) {
                Nio2Session.this.handleReadCycleCompletion(buffer, bufReader, this, result, attachment);
            }

            @Override
            protected void onFailed(Throwable exc, Object attachment) {
                Nio2Session.this.handleReadCycleFailure(buffer, bufReader, exc, attachment);
            }
        };
    }

    protected void handleReadCycleCompletion(ByteBuffer buffer, Readable bufReader, Nio2CompletionHandler<Integer, Object> completionHandler, Integer result, Object attachment) {
        try {
            if (result >= 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleReadCycleCompletion({}) read {} bytes", (Object)this, (Object)result);
                }
                buffer.flip();
                IoHandler handler = this.getIoHandler();
                handler.messageReceived(this, bufReader);
                if (!this.closeFuture.isClosed()) {
                    buffer.clear();
                    this.doReadCycle(buffer, completionHandler);
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("handleReadCycleCompletion({}) IoSession has been closed, stop reading", (Object)this);
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleReadCycleCompletion({}) Socket has been disconnected (result={}), closing IoSession now", (Object)this, (Object)result);
                }
                this.close(true);
            }
        }
        catch (Throwable exc) {
            completionHandler.failed(exc, attachment);
        }
    }

    protected void handleReadCycleFailure(ByteBuffer buffer, Readable bufReader, Throwable exc, Object attachment) {
        this.exceptionCaught(exc);
    }

    protected void doReadCycle(ByteBuffer buffer, Nio2CompletionHandler<Integer, Object> completion) {
        AsynchronousSocketChannel socket = this.getSocket();
        long readTimeout = this.manager.getLongProperty("nio2-read-timeout", FactoryManager.DEFAULT_NIO2_READ_TIMEOUT);
        socket.read(buffer, readTimeout, TimeUnit.MILLISECONDS, null, completion);
    }

    protected void startWriting() {
        Nio2DefaultIoWriteFuture future = this.writes.peek();
        if (future != null && this.currentWrite.compareAndSet(null, future)) {
            try {
                AsynchronousSocketChannel socket = this.getSocket();
                ByteBuffer buffer = future.getBuffer();
                Nio2CompletionHandler<Integer, Object> handler = Objects.requireNonNull(this.createWriteCycleCompletionHandler(future, socket, buffer), "No write cycle completion handler created");
                this.doWriteCycle(buffer, handler);
            }
            catch (Throwable e) {
                future.setWritten();
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeSshException(e);
            }
        }
    }

    protected void doWriteCycle(ByteBuffer buffer, Nio2CompletionHandler<Integer, Object> completion) {
        AsynchronousSocketChannel socket = this.getSocket();
        long writeTimeout = this.manager.getLongProperty("nio2-min-write-timeout", FactoryManager.DEFAULT_NIO2_MIN_WRITE_TIMEOUT);
        socket.write(buffer, writeTimeout, TimeUnit.MILLISECONDS, null, completion);
    }

    protected Nio2CompletionHandler<Integer, Object> createWriteCycleCompletionHandler(final Nio2DefaultIoWriteFuture future, final AsynchronousSocketChannel socket, final ByteBuffer buffer) {
        final int writeLen = buffer.remaining();
        return new Nio2CompletionHandler<Integer, Object>(){

            @Override
            protected void onCompleted(Integer result, Object attachment) {
                Nio2Session.this.handleCompletedWriteCycle(future, socket, buffer, writeLen, this, result, attachment);
            }

            @Override
            protected void onFailed(Throwable exc, Object attachment) {
                Nio2Session.this.handleWriteCycleFailure(future, socket, buffer, writeLen, exc, attachment);
            }
        };
    }

    protected void handleCompletedWriteCycle(Nio2DefaultIoWriteFuture future, AsynchronousSocketChannel socket, ByteBuffer buffer, int writeLen, Nio2CompletionHandler<Integer, Object> completionHandler, Integer result, Object attachment) {
        if (buffer.hasRemaining()) {
            try {
                socket.write(buffer, null, completionHandler);
            }
            catch (Throwable t) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleCompletedWriteCycle(" + this + ") Exception caught while writing " + writeLen + " bytes", t);
                }
                future.setWritten();
                this.finishWrite(future);
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleCompletedWriteCycle({}) finished writing len={}", (Object)this, (Object)writeLen);
            }
            future.setWritten();
            this.finishWrite(future);
        }
    }

    protected void handleWriteCycleFailure(Nio2DefaultIoWriteFuture future, AsynchronousSocketChannel socket, ByteBuffer buffer, int writeLen, Throwable exc, Object attachment) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleWriteCycleFailure({}) failed ({}) to write {} bytes: {}", this, exc.getClass().getSimpleName(), writeLen, exc.getMessage());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleWriteCycleFailure(" + this + ") len=" + writeLen + " failure details", exc);
        }
        future.setException(exc);
        this.exceptionCaught(exc);
        this.finishWrite(future);
    }

    protected void finishWrite(Nio2DefaultIoWriteFuture future) {
        this.writes.remove(future);
        this.currentWrite.compareAndSet(future, null);
        this.startWriting();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[local=" + this.getLocalAddress() + ", remote=" + this.getRemoteAddress() + "]";
    }
}

