/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform.process;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.Rule;
import org.parboiled.annotations.Label;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.process.RuleMethodProcessor;

public class LabellingGenerator
implements RuleMethodProcessor {
    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull(classNode, "classNode");
        Preconditions.checkNotNull(method, "method");
        return !method.hasDontLabelAnnotation();
    }

    @Override
    public void process(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) throws Exception {
        Preconditions.checkNotNull(classNode, "classNode");
        Preconditions.checkNotNull(method, "method");
        Preconditions.checkState(!method.isSuperMethod());
        InsnList instructions = method.instructions;
        AbstractInsnNode ret = instructions.getLast();
        while (ret.getOpcode() != 176) {
            ret = ret.getPrevious();
        }
        LabelNode isNullLabel = new LabelNode();
        instructions.insertBefore(ret, new InsnNode(89));
        instructions.insertBefore(ret, new JumpInsnNode(198, isNullLabel));
        instructions.insertBefore(ret, new LdcInsnNode(LabellingGenerator.getLabelText(method)));
        instructions.insertBefore(ret, new MethodInsnNode(185, CodegenUtils.p(Rule.class), "label", CodegenUtils.sig(Rule.class, String.class), true));
        instructions.insertBefore(ret, isNullLabel);
    }

    public static String getLabelText(RuleMethod method) {
        if (method.visibleAnnotations == null) {
            return method.name;
        }
        Iterator i$ = method.visibleAnnotations.iterator();
        while (i$.hasNext()) {
            AnnotationNode annotationObj;
            AnnotationNode annotation = annotationObj = (AnnotationNode)i$.next();
            if (!annotation.desc.equals(CodegenUtils.ci(Label.class)) || annotation.values == null) continue;
            Preconditions.checkState("value".equals(annotation.values.get(0)));
            String labelValue = (String)annotation.values.get(1);
            return labelValue.isEmpty() ? method.name : labelValue;
        }
        return method.name;
    }
}

