/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.gerrit.httpd.RequestMetrics;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.servlet.ServletModule;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

@Singleton
public class RequestMetricsFilter
implements Filter {
    private final RequestMetrics metrics;

    public static Module module() {
        return new ServletModule(){

            @Override
            protected void configureServlets() {
                this.filter("/*", new String[0]).through(RequestMetricsFilter.class);
            }
        };
    }

    @Inject
    RequestMetricsFilter(RequestMetrics metrics) {
        this.metrics = metrics;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Response rsp = new Response((HttpServletResponse)response, this.metrics);
        chain.doFilter(request, rsp);
    }

    @Override
    public void init(FilterConfig cfg) throws ServletException {
    }

    private static class Response
    extends HttpServletResponseWrapper {
        private final RequestMetrics metrics;

        Response(HttpServletResponse response, RequestMetrics metrics) {
            super(response);
            this.metrics = metrics;
        }

        @Override
        public void sendError(int sc, String msg) throws IOException {
            this.status(sc);
            super.sendError(sc, msg);
        }

        @Override
        public void sendError(int sc) throws IOException {
            this.status(sc);
            super.sendError(sc);
        }

        @Override
        @Deprecated
        public void setStatus(int sc, String sm) {
            this.status(sc);
            super.setStatus(sc, sm);
        }

        @Override
        public void setStatus(int sc) {
            this.status(sc);
            super.setStatus(sc);
        }

        private void status(int sc) {
            if (sc >= 400) {
                this.metrics.errors.increment(sc);
            } else {
                this.metrics.successes.increment(sc);
            }
        }
    }
}

